/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.type.annotation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.document.aspect.common.CommonAspect;
import de.intarsys.document.aspect.common.CommonAspectType;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationControl;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnnotationsAspect
extends CommonAspect {
    private List<DtoAnnotationControl> annotationControls = new ArrayList<DtoAnnotationControl>();
    @JsonIgnore
    private Set<String> knownAnnotationControls = new HashSet<String>();

    public AnnotationsAspect(CommonAspectType type, IDocument document) {
        super(type, document);
    }

    public void addAnnotationControl(DtoAnnotationControl control) {
        if (this.addKnownAnnotationControl(control)) {
            this.annotationControls.add(control);
        }
    }

    public boolean addKnownAnnotationControl(DtoAnnotationControl control) {
        if (StringTools.isEmpty((String)control.getName())) {
            return true;
        }
        return this.knownAnnotationControls.add(control.getName());
    }

    public DtoAnnotationControl getAnnotationControl(String name) {
        if (StringTools.isEmpty((String)name)) {
            return null;
        }
        return this.annotationControls.stream().filter(control -> name.equals(control.getName())).findAny().orElse(null);
    }

    public List<DtoAnnotationControl> getAnnotationControls() {
        return this.annotationControls;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    public Set<String> getKnownAnnotationControls() {
        return this.knownAnnotationControls;
    }

    public boolean hasAnnotations(String name) {
        return this.knownAnnotationControls.contains(name);
    }

    public void setAnnotationControls(List<DtoAnnotationControl> annotationControls) {
        this.annotationControls = annotationControls;
    }

    public void setKnownAnnotationControls(Set<String> knownAnnotationControls) {
        this.knownAnnotationControls = knownAnnotationControls;
    }
}

