/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.type.annotation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationAppearance;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.widget.model.ICallbackSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DtoAnnotationControl
implements ICallbackSupport {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String text;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String modified;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String created;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String content;
    private Map<String, Object> properties;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, IMethodHandler> callbacks;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<DtoAnnotationAppearance> appearances = new ArrayList<DtoAnnotationAppearance>();

    public DtoAnnotationControl() {
    }

    public DtoAnnotationControl(String name) {
        this.setName(name);
    }

    public void addAppearance(DtoAnnotationAppearance appearance) {
        this.appearances.add(appearance);
    }

    public List<DtoAnnotationAppearance> getAppearances() {
        return this.appearances;
    }

    public IMethodHandler getCallback(String name) {
        if (this.callbacks == null) {
            return null;
        }
        return this.callbacks.get(name);
    }

    public Map<String, IMethodHandler> getCallbacks() {
        if (this.callbacks == null) {
            return Collections.emptyMap();
        }
        return this.callbacks;
    }

    public String getContent() {
        return this.content;
    }

    public String getCreated() {
        return this.created;
    }

    public String getModified() {
        return this.modified;
    }

    public String getName() {
        return this.name;
    }

    @JsonAnyGetter
    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        if ("type".equals(name)) {
            return this.getType();
        }
        if ("subType".equals(name)) {
            return this.getSubType();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public void setAppearances(List<DtoAnnotationAppearance> appearances) {
        this.appearances = appearances;
    }

    public void setCallback(String eventName, IMethodHandler callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashMap<String, IMethodHandler>();
        }
        this.callbacks.put(eventName, callback);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setModified(String date) {
        this.modified = date;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonAnySetter
    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setText(String name) {
        this.text = name;
    }

    public void setType(String type) {
        this.type = type;
    }
}

