/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.type.rendering;

import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import jakarta.ws.rs.InternalServerErrorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class RenderingTools {
    public static final int BUFFER_SIZE = 100000;
    public static final double PERCENTILE = 100.0;

    private RenderingTools() {
    }

    public static byte[] writeImage(BufferedImage bufferedImage, RenderingParameters renderParams) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(100000);
        String format = renderParams.getFormat();
        ImageWriter imgWriter = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam imgParam = imgWriter.getDefaultWriteParam();
        if (imgParam.canWriteCompressed()) {
            imgParam.setCompressionMode(2);
            imgParam.setCompressionQuality((float)((double)renderParams.getCompression() / 100.0));
        }
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(os);
        imgWriter.setOutput(outputStream);
        IIOImage outputImage = new IIOImage(bufferedImage, null, null);
        try {
            imgWriter.write(null, outputImage, imgParam);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("error writing image", (Throwable)e);
        }
        imgWriter.dispose();
        return os.toByteArray();
    }
}

