/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.documents.aspect.type.printer;

import de.intarsys.document.aspect.IStreamingAspect;
import de.intarsys.document.aspect.common.CommonAspect;
import de.intarsys.document.aspect.common.CommonAspectType;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.jaxrs.IResponseCustomizer;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PrinterAspect
extends CommonAspect
implements IStreamingAspect,
IResponseCustomizer {
    private String format;
    private ILocator locator;
    private Boolean isFileExtnRequired = false;

    public PrinterAspect(CommonAspectType type, IDocument document) {
        super(type, document);
    }

    public void customize(Response.ResponseBuilder builder) {
        String fileExtension = ".pdf";
        String fileName = this.locator.getName();
        if (this.isFileExtnRequired.booleanValue() && fileName != null) {
            fileName = fileName.concat(".pdf");
        }
        builder.header("Content-Disposition", (Object)("filename=\"" + fileName + "\""));
    }

    @Override
    public String getContentType() {
        return "application/" + this.getFormat();
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getIsFileExtnRequired() {
        return this.isFileExtnRequired;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setIsFileExtnRequired(Boolean isFileExtnRequired) {
        this.isFileExtnRequired = isFileExtnRequired;
    }

    public void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getLocator().getInputStream();
            StreamTools.copy((InputStream)inputStream, (OutputStream)os);
            os.flush();
        }
        finally {
            StreamTools.close((Closeable)inputStream);
            this.getLocator().delete();
        }
    }
}

