/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.spring.security.DtoErrorWithRedirect;
import de.intarsys.tools.jaxrs.JaxrsTools;
import de.intarsys.tools.jaxrs.exception.DtoError;
import de.intarsys.tools.jaxrs.exception.ResponseError;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class ApiRedirectUnauthorizedAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final String ERR_UNAUTHORIZED = "Unauthorized";
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger Log = LoggerFactory.getLogger(ApiRedirectUnauthorizedAuthenticationEntryPoint.class);
    private String redirectUri;

    public ApiRedirectUnauthorizedAuthenticationEntryPoint(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        Log.trace("{} reply UNAUTHORIZED", (Object)this);
        response.addHeader("WWW-Authenticate", "API-Redirect");
        response.setHeader("content-type", "application/json");
        response.setStatus(401);
        ResponseError error = new ResponseError();
        DtoErrorWithRedirect detail = new DtoErrorWithRedirect();
        detail.setCode(ERR_UNAUTHORIZED);
        detail.setMessage(exception.getMessage());
        URI redirectUri = JaxrsTools.getUriBuilderContext().path(this.getRedirectUri()).build(new Object[0]);
        detail.setRedirectUri(redirectUri.toURL().toExternalForm());
        error.setError((DtoError)detail);
        mapper.writeValue((OutputStream)response.getOutputStream(), (Object)error);
        response.flushBuffer();
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }
}

