/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.rendering.misc;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.platform.cwt.rendering.CSPlatformRenderer;
import de.intarsys.pdf.rendering.misc.ContentStreamRenderer;
import de.intarsys.pdf.rendering.page.PageRenderingOption;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldContentRenderer
extends ContentStreamRenderer {
    protected PDAppearance createAppearance(PDAnnotation annotation) {
        PDAppearance appearance = (PDAppearance)PDAppearance.META.createNew();
        IAppearanceCreator appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(annotation.cosGetSubtype());
        if (appearanceCreator != null) {
            appearance = appearanceCreator.createAppearance(annotation, appearance);
        }
        return appearance;
    }

    protected CSPlatformRenderer createCSRenderer(PDAnnotation annotation, Map options, IGraphicsContext graphics) {
        return this.createCSRenderer(options, graphics);
    }

    protected boolean isCheckboxCross(PDAnnotation annotation) {
        String captionString;
        if (!annotation.isWidgetAnnotation()) {
            return false;
        }
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAcroFormField field = widget.getAcroFormField();
        if (!field.isTypeBtn() || field.getFieldFlags().isPushbutton() || field.getFieldFlags().isRadio()) {
            return false;
        }
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        return "8".equals(captionString = apc.getNormalCaption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAnnotation(PDAnnotation annotation, Rectangle2D container, Map options, IGraphicsContext graphics) {
        PDForm form;
        PDAppearance appearance;
        if (annotation.isHidden()) {
            return;
        }
        if (PageRenderingOption.isPrintMode(options) ? !annotation.isPrint() : annotation.isNoView()) {
            return;
        }
        COSName state = annotation.getAppearanceState();
        COSName appearanceKey = null;
        if (!PageRenderingOption.isPrintMode(options)) {
            appearanceKey = (COSName)annotation.getAttribute(PDAppearance.class);
        }
        if (appearanceKey == null) {
            appearanceKey = PDAppearance.DK_N;
        }
        if ((appearance = annotation.getAppearance()) == null || !appearance.isDefined(appearanceKey, state) || this.isCheckboxCross(annotation) && !appearance.isDefined(appearanceKey, null)) {
            appearance = this.createAppearance(annotation);
        }
        if ((form = appearance.getAppearance(appearanceKey, state)) == null) {
            return;
        }
        CDSMatrix matrix = form.getMatrix();
        Rectangle2D tbbox = form.getTransformedBBox();
        Shape oldClip = graphics.getClip();
        AffineTransform current = graphics.getTransform();
        try {
            AffineTransform transform = new AffineTransform();
            if (container != null) {
                Rectangle2D.Float annotClipRect = new Rectangle2D.Float((float)(container.getX() - 1.5), (float)(container.getY() - 1.5), (float)(container.getWidth() + 3.0), (float)(container.getHeight() + 3.0));
                graphics.clip((Shape)annotClipRect);
                transform.translate(container.getMinX(), container.getMinY());
                float sx = (float)(container.getWidth() / tbbox.getWidth());
                float sy = (float)(container.getHeight() / tbbox.getHeight());
                transform.scale(sx, sy);
            }
            transform.translate(-tbbox.getX(), -tbbox.getY());
            if (matrix != null) {
                transform.concatenate(matrix.toTransform());
            }
            graphics.transform(transform);
            CSContent content = form.getContentStream();
            CSPlatformRenderer processor = this.createCSRenderer(annotation, options, graphics);
            try {
                processor.process(content, form.getResources());
            }
            catch (CSException cSException) {
                // empty catch block
            }
        }
        finally {
            graphics.setTransform(current);
            graphics.setClip(oldClip);
        }
    }

    @Override
    public void renderPage(PDPage page, Map<String, String> options, IGraphicsContext graphics) {
        graphics.setRenderingHints(new HashMap());
        List annots = page.getAnnotations();
        if (annots == null) {
            return;
        }
        for (PDAnnotation annotation : annots) {
            try {
                this.renderAnnotation(annotation, annotation.getRectangle().toNormalizedRectangle(), options, graphics);
            }
            catch (RuntimeException runtimeException) {}
        }
    }
}

