/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.rendering.misc;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.rendering.page.AbstractPageRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldDefinitionRenderer
extends AbstractPageRenderer {
    public static final Color DEFAULT_BORDERCOLOR = new Color(200, 0, 0);
    public static final Color DEFAULT_FILLCOLOR = new Color(200, 200, 200);
    public static final Color DEFAULT_TEXTCOLOR = new Color(0, 0, 0);
    public static final Font DEFAULT_TEXTFONT = new Font("SansSerif", 0, 12);
    private Color borderColor = DEFAULT_BORDERCOLOR;
    private boolean borderEnabled = true;
    private Color fillColor = DEFAULT_FILLCOLOR;
    private boolean fillEnabled = true;
    private Color textColor = DEFAULT_TEXTCOLOR;
    private Font textFont = DEFAULT_TEXTFONT;

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public boolean isBorderEnabled() {
        return this.borderEnabled;
    }

    public boolean isFillEnabled() {
        return this.fillEnabled;
    }

    @Override
    public void renderPage(PDPage page, Map<String, String> options, IGraphicsContext graphics) {
        AffineTransform transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        Font transformedFont = this.getTextFont().deriveFont(transform);
        graphics.setRenderingHints(new HashMap());
        Rectangle2D rect = page.getCropBox().toNormalizedRectangle();
        graphics.clip((Shape)rect);
        graphics.setForegroundColor(new Color(255, 255, 255));
        graphics.fill((Shape)rect);
        List annots = page.getAnnotations();
        if (annots == null) {
            return;
        }
        for (PDAnnotation annotation : annots) {
            this.renderRectangle(annotation, options, graphics);
        }
        for (PDAnnotation annotation : annots) {
            this.renderText(annotation, options, graphics, transformedFont);
        }
    }

    protected void renderRectangle(PDAnnotation annotation, Map options, IGraphicsContext graphics) {
        Rectangle2D rect = annotation.getRectangle().toNormalizedRectangle();
        if (this.isFillEnabled()) {
            graphics.setForegroundColor(this.getFillColor());
            graphics.fill((Shape)rect);
        }
        if (this.isBorderEnabled()) {
            graphics.setForegroundColor(this.getBorderColor());
            graphics.setStroke((Stroke)new BasicStroke(1.0f));
            graphics.draw((Shape)rect);
        }
    }

    protected void renderText(PDAnnotation annotation, Map options, IGraphicsContext graphics, Font font) {
        Rectangle2D rect = annotation.getRectangle().toNormalizedRectangle();
        String name = null;
        name = annotation instanceof PDWidgetAnnotation ? ((PDWidgetAnnotation)annotation).getAcroFormField().getQualifiedName() : annotation.getName();
        if (name == null) {
            name = "<unknown>";
        }
        graphics.setFont(font);
        graphics.setForegroundColor(this.getTextColor());
        graphics.drawString(name, (float)rect.getMinX() + 1.0f, (float)rect.getMinY() + 1.0f);
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderEnabled(boolean borderEnabled) {
        this.borderEnabled = borderEnabled;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setFillEnabled(boolean fillEnabled) {
        this.fillEnabled = fillEnabled;
    }

    public void setTextColor(Color fontColor) {
        this.textColor = fontColor;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }
}

