/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.rendering.misc;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.rendering.page.AbstractPageRenderer;
import de.intarsys.pdf.rendering.page.IPageRenderingExceptionHandler;
import de.intarsys.pdf.rendering.page.PageRenderingException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.util.Map;

public class SimpleTextRenderer
extends AbstractPageRenderer {
    private String text;

    public SimpleTextRenderer() {
    }

    public SimpleTextRenderer(String text) {
        this.text = text;
    }

    @Override
    public IPageRenderingExceptionHandler getExceptionHandler() {
        return null;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void renderPage(PDPage page, Map<String, String> options, IGraphicsContext gc) throws PageRenderingException {
        gc.setBackgroundColor(Color.WHITE);
        gc.fill((Shape)page.getCropBox().toNormalizedRectangle());
        gc.setForegroundColor(Color.BLACK);
        gc.setFont(Font.getFont("Helvetica"));
        gc.scale(1.0f, -1.0f);
        gc.drawString(this.getText(), 100.0f, 100.0f);
        gc.drawString(this.getText(), 100.0f, -100.0f);
    }

    @Override
    public void setExceptionHandler(IPageRenderingExceptionHandler exceptionHandler) {
    }

    public void setText(String text) {
        this.text = text;
    }
}

