/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.rendering.page;

import de.intarsys.pdf.rendering.page.IPageRenderer;
import de.intarsys.pdf.rendering.page.IPageRenderingExceptionHandler;
import de.intarsys.pdf.rendering.page.PageRenderingError;
import de.intarsys.pdf.rendering.page.PageRenderingException;
import de.intarsys.pdf.rendering.page.PageRenderingWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPageRenderer
implements IPageRenderer {
    private List errors = Collections.EMPTY_LIST;
    private List warnings = Collections.EMPTY_LIST;
    private IPageRenderingExceptionHandler exceptionHandler;

    protected AbstractPageRenderer() {
    }

    public List getErrors() {
        List result = this.errors;
        this.errors = Collections.EMPTY_LIST;
        return result;
    }

    @Override
    public IPageRenderingExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public List getWarnings() {
        List result = this.warnings;
        this.warnings = Collections.EMPTY_LIST;
        return result;
    }

    protected void handleError(PageRenderingError error) throws PageRenderingException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.error(error);
        } else if (this.errors == Collections.EMPTY_LIST) {
            this.errors = new ArrayList();
        }
    }

    protected void handleWarning(PageRenderingWarning warning) throws PageRenderingException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.warning(warning);
        } else if (this.warnings == Collections.EMPTY_LIST) {
            this.warnings = new ArrayList();
        }
    }

    @Override
    public void setExceptionHandler(IPageRenderingExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

