/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.rendering.page;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.common.CSContentTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.platform.cwt.rendering.CSPlatformRenderer;
import de.intarsys.pdf.rendering.misc.PageContentRenderer;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public class PageRenderingTools {
    public static void renderForm(PDForm form, Rectangle2D rect, IGraphicsContext igc) {
        Rectangle2D formrect = form.getBoundingBox().toNormalizedRectangle();
        double factorX = rect.getWidth() / formrect.getWidth();
        double factorY = rect.getHeight() / formrect.getHeight();
        double scale = Math.min(factorX, factorY);
        AffineTransform transform = new AffineTransform();
        transform.translate(rect.getMinX(), rect.getMinY());
        transform.scale(scale, -scale);
        transform.translate(-formrect.getMinX(), -formrect.getMaxY());
        igc.transform(transform);
        HashMap options = new HashMap();
        CSPlatformRenderer renderer = new CSPlatformRenderer(options, igc);
        try {
            renderer.process(form.getContentStream(), form.getResources());
        }
        catch (CSException cSException) {
            // empty catch block
        }
    }

    public static void renderPageClipped(PDPage page, Rectangle2D rect, IGraphicsContext igc) {
        Rectangle2D pagerect = CSContentTools.getBoundingBoxClipped((PDPage)page, (double)0.0);
        double factorX = rect.getWidth() / pagerect.getWidth();
        double factorY = rect.getHeight() / pagerect.getHeight();
        double scale = Math.min(factorX, factorY);
        AffineTransform transform = new AffineTransform();
        transform.translate(rect.getMinX(), rect.getMinY());
        transform.scale(scale, -scale);
        transform.translate(0.0, -pagerect.getHeight());
        PDFGeometryTools.applyPageSpace((int)page.getNormalizedRotate(), (Rectangle2D)pagerect, (AffineTransform)transform);
        igc.transform(transform);
        PageContentRenderer renderer = new PageContentRenderer();
        HashMap<String, String> options = new HashMap<String, String>();
        renderer.renderPage(page, options, igc);
    }
}

