/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.app;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.ILicenseAccountSupport;

public abstract class PoolSecurityApplication<T extends ISecurityApplication>
extends CommonSecurityApplication {
    private final PoolEntry<T> poolEntry;

    protected PoolSecurityApplication(CommonDevice device, PoolEntry<T> entry) {
        super(device);
        this.poolEntry = entry;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.getPoolEntry().getSecurityApplication().reset();
        this.getPoolEntry().release();
    }

    protected void basicReset() {
        super.basicReset();
        this.getPoolEntry().getSecurityApplication().reset();
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        T t = this.getWrapped();
        if (t instanceof IStringEvaluator) {
            IStringEvaluator evaluator = (IStringEvaluator)t;
            return evaluator.evaluate(expression, args);
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public String getLabel() {
        return this.basicIsDisposed() ? "disposed " + this.getPoolEntry().getLabel() : this.getPoolEntry().getLabel();
    }

    public ILicenseAccount getLicenseAccount() {
        if (this.getWrapped() instanceof ILicenseAccountSupport) {
            return ((ILicenseAccountSupport)this.getWrapped()).getLicenseAccount();
        }
        return null;
    }

    protected PoolEntry<T> getPoolEntry() {
        return this.poolEntry;
    }

    public T getWrapped() {
        return this.getPoolEntry().getSecurityApplication();
    }

    public boolean isDisposed() {
        return super.isDisposed() || this.getWrapped().isDisposed();
    }

    public boolean isValid() {
        return super.isValid() && this.getPoolEntry().isValid();
    }
}

