/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.app;

import de.intarsys.aaa.authorization.api.AuthorizationException;
import de.intarsys.security.app.RetryException;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.pool.app.PoolSecurityApplication;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.exception.ExceptionTools;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolSigner<T extends ISigner>
extends PoolSecurityApplication<T>
implements ISigner {
    private static final Logger Log = LoggerFactory.getLogger(PoolSigner.class);

    public PoolSigner(PoolDevice device, PoolEntry<T> entry) {
        super(device, entry);
    }

    public void buildCertificatePath() {
        ((ISigner)this.getWrapped()).buildCertificatePath();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return ((ISigner)this.getWrapped()).getAlgorithmParameterSpec();
    }

    public int getApproximatedContainerSize() {
        return ((ISigner)this.getWrapped()).getApproximatedContainerSize();
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return ((ISigner)this.getWrapped()).getCertificatePath();
    }

    public PoolDevice getDevice() {
        return (PoolDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return ((ISigner)this.getWrapped()).getEncryptionAlgorithmName();
    }

    public String getHashAlgorithmName() {
        return ((ISigner)this.getWrapped()).getHashAlgorithmName();
    }

    public String getPreferredHashAlgorithmName() {
        return ((ISigner)this.getWrapped()).getPreferredHashAlgorithmName();
    }

    public IPrincipal getPrincipal() {
        IX509PublicKeyCertificate cert = ((ISigner)this.getPoolEntry().getSecurityApplication()).getCertificatePath()[0];
        return this.getDevice().createPrincipal((IX509Certificate)cert);
    }

    protected String getPublishCodePrefix() {
        return "sign";
    }

    public SignatureFormat getSignatureFormat() {
        return ((ISigner)this.getWrapped()).getSignatureFormat();
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return ((ISigner)this.getWrapped()).getSupportedHashAlgorithmNames();
    }

    public boolean isBasic() {
        return ((ISigner)this.getWrapped()).isBasic();
    }

    protected boolean isRetry(Throwable t) {
        return !(t instanceof AuthorizationException);
    }

    public void setHashAlgorithmName(String name) throws SecurityApplicationException {
        ((ISigner)this.getWrapped()).setHashAlgorithmName(name);
    }

    public void setSignatureFormat(SignatureFormat family) {
        ((ISigner)this.getWrapped()).setSignatureFormat(family);
    }

    public void setSignatureOptions(SignatureOptions options) {
        ((ISigner)this.getWrapped()).setSignatureOptions(options);
    }

    public IConversation<ISignatureData> sign(IToBeSignedData data) {
        if (this.basicIsDisposed()) {
            return Conversation.failed((Throwable)new SecurityApplicationException("disposed"));
        }
        SignerTools.checkAccess((IDevice)this.getDevice());
        if (!this.getPoolEntry().check()) {
            return Conversation.failed((Throwable)new RetryException());
        }
        IConversation conversation = ((ISigner)this.getWrapped()).sign(data);
        conversation = conversation.exceptionally(ex -> {
            Throwable unwrapped = ExceptionTools.unwrap((Throwable)ex);
            if (this.isRetry(unwrapped)) {
                Log.debug("pooled signer exception, ignore and retry {}", (Object)ExceptionTools.getMessage((Throwable)unwrapped));
                this.getPoolEntry().incRetriesOnExceptionCount();
                throw new RetryException(unwrapped);
            }
            throw Conversation.rethrowable((Throwable)unwrapped);
        });
        return conversation;
    }

    public IConversation<Void> signAbort() {
        return ((ISigner)this.getWrapped()).signAbort();
    }

    public IConversation<Void> signBegin() {
        return ((ISigner)this.getWrapped()).signBegin();
    }

    public IConversation<ISignatureDataList> signCommit() {
        return ((ISigner)this.getWrapped()).signCommit();
    }

    public IConversation<Void> signPrepare() {
        return ((ISigner)this.getWrapped()).signPrepare();
    }
}

