/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.app;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.pool.app.PoolSecurityApplicationFactory;
import de.intarsys.security.device.pool.app.PoolSigner;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.PoolResourceNotAvailable;
import de.intarsys.security.device.pool.impl.PoolStopped;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.CommonMessages;
import de.intarsys.tools.reflect.ObjectCreationException;

public class PoolSignerFactory
extends PoolSecurityApplicationFactory<PoolSigner> {
    protected PoolSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        GenericPool<ISecurityApplication> pool = ((PoolDevice)this.getDevice(args)).getPool();
        if (!pool.isStarted() && pool.isAutoStart()) {
            pool.start();
        }
        try {
            Object entry = pool.checkout(this.getTimeout(args));
            PoolSigner signer = new PoolSigner((PoolDevice)this.getDevice(args), entry);
            return signer;
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (PoolResourceNotAvailable e) {
            throw new ObjectCreationException(e.getMessage(), (Throwable)e);
        }
        catch (PoolStopped e) {
            throw new ObjectCreationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            String msg = CommonMessages.INTERNAL_ERROR.getString();
            throw new ObjectCreationException(msg, (Throwable)e);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    public Class<PoolSigner> getResultType() {
        return PoolSigner.class;
    }
}

