/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.claptz;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.device.PoolDeviceProvider;
import de.intarsys.security.device.pool.impl.CommonPool;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PoolInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(PoolInstaller.class);
    public static final String XE_POOL = "pool";
    public static final String XP_POOLSIGNING = "de.intarsys.security.device.pool.signing";

    protected Object basicInstallDelete(IExtension extension, IElement element) {
        if (XE_POOL.equals(element.getName())) {
            String id = element.attributeValue("id", null);
            PoolDeviceProvider provider = (PoolDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(PoolDeviceProvider.class));
            if (provider != null) {
                Iterator iterator = provider.iterator();
                while (iterator.hasNext()) {
                    PoolDevice device = (PoolDevice)((Object)iterator.next());
                    if (!device.getId().equals(id)) continue;
                    provider.unregisterDevice(device);
                    return device.getPool();
                }
            }
            return null;
        }
        return super.basicInstallDelete(extension, element);
    }

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_POOL.equals(element.getName())) {
            try {
                CommonPool pool = (CommonPool)ElementTools.createObject((IElement)element, CommonPool.class, (Object)extension.getProvider(), (IArgs)Args.create());
                PoolDeviceProvider provider = (PoolDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(PoolDeviceProvider.class));
                Args args = Args.create();
                args.put(XE_POOL, (Object)pool);
                provider.createInstance((IArgs)args);
                return pool;
            }
            catch (ObjectCreationException e) {
                String msg = "error creating object";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
            catch (LicenseException e) {
                String msg = "license error";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        if (XE_POOL.equals(element.getName())) {
            try {
                String id = element.attributeValue("id", null);
                PoolDeviceProvider provider = (PoolDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(PoolDeviceProvider.class));
                if (provider == null) {
                    return null;
                }
                Iterator iterator = provider.iterator();
                while (iterator.hasNext()) {
                    PoolDevice device = (PoolDevice)((Object)iterator.next());
                    if (!device.getId().equals(id)) continue;
                    if (device.getPool() instanceof IElementConfigurable) {
                        device.getPool().configure(element);
                    }
                    return device.getPool();
                }
                String msg = "no pool with id " + id;
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
            catch (Exception e) {
                String msg = "error creating pool";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallUpdate(extension, element);
        }
        return null;
    }
}

