/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.claptz;

import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.pool.claptz.PACKAGE;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.device.PoolDeviceProvider;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.concurrent.ExecutorEnvironment;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reporter.Reporter;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanComponent(role="container.lifecycle")
public class PoolLauncher
implements IStartStop {
    private static final Logger Log = LoggerFactory.getLogger(PoolLauncher.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Object lock = new Object();
    private boolean started = false;

    protected void basicStart() {
        for (PoolDeviceProvider provider : DeviceTools.lookupDeviceProviders(PoolDeviceProvider.class)) {
            Iterator iterator = provider.iterator();
            while (iterator.hasNext()) {
                PoolDevice device = (PoolDevice)((Object)iterator.next());
                if (!device.getPool().isAutoStart()) continue;
                try {
                    device.getPool().start();
                }
                catch (Exception e) {
                    Reporter.get().reportError(Msg.getString("PoolLauncher.reporter.title", new Object[0]), Msg.getString("PoolLauncher.errorFailedStarting", new Object[]{device.getId()}), (Throwable)e, 0);
                }
            }
        }
    }

    protected void basicStop() {
        for (PoolDeviceProvider provider : DeviceTools.lookupDeviceProviders(PoolDeviceProvider.class)) {
            Iterator iterator = provider.iterator();
            while (iterator.hasNext()) {
                PoolDevice device = (PoolDevice)((Object)iterator.next());
                try {
                    device.getPool().stop();
                }
                catch (Exception e) {
                    Reporter.get().reportError(Msg.getString("PoolLauncher.reporter.title", new Object[0]), Msg.getString("PoolLauncher.errorFailedStopping", new Object[]{device.getId()}), (Throwable)e, 0);
                }
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        Log.debug("signature pool launcher starting");
        ExecutorEnvironment.get().getService().execute(new Runnable(){

            @Override
            public void run() {
                PoolLauncher.this.basicStart();
                Log.debug("signature pool launcher started");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        Log.debug("signature pool launcher stopping");
        this.basicStop();
        Log.debug("signature pool launcher stopped");
    }

    public boolean stopRequested(Set visited) {
        return true;
    }
}

