/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.device;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.health.CommonDeviceHealth;
import de.intarsys.security.device.pool.device.PACKAGE;
import de.intarsys.security.device.pool.device.PoolDeviceProvider;
import de.intarsys.security.device.pool.device.PoolPrincipal;
import de.intarsys.security.device.pool.health.PoolDeviceHealth;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.security.device.pool.jmx.JmxPoolDevice;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.ResumedEvent;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.event.SuspendedEvent;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.NoticeEvent;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reporter.Reporter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.management.NotificationBroadcasterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=PoolDeviceProvider.class)
public class PoolDevice
extends CommonDevice<PoolDeviceProvider> {
    public static final String LIC_PRODUCT = "de.intarsys.security.device.pool";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(PoolDevice.class);
    private GenericPool<ISecurityApplication> pool;
    private IPoolListener poolListener;
    private final Attribute ATTR_PRINCIPAL = new Attribute("principal");
    private final INotificationListener poolNotificationListener = new INotificationListener(){

        public void handleEvent(Event event) {
            if (event.getEventType() == StartedEvent.ID) {
                PoolDevice.this.mbeanSendNotification("pool.started", "Pool '" + PoolDevice.this.getId() + "' started", 10);
            } else if (event.getEventType() == StoppedEvent.ID) {
                PoolDevice.this.mbeanSendNotification("pool.stopped", "Pool '" + PoolDevice.this.getId() + "' stopped", 10);
            } else if (event.getEventType() == ResumedEvent.ID) {
                PoolDevice.this.mbeanSendNotification("pool.resumed", "Pool '" + PoolDevice.this.getId() + "' resumed", 10);
            } else if (event.getEventType() == SuspendedEvent.ID) {
                PoolDevice.this.mbeanSendNotification("pool.suspended", "Pool '" + PoolDevice.this.getId() + "' suspended", 10);
            } else if (event.getEventType() == NoticeEvent.ID) {
                PoolDevice.this.sendNotification(((NoticeEvent)event).getNotice());
            }
        }
    };

    protected PoolDevice(PoolDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    protected void basicOnContextClosed() {
        super.basicOnContextClosed();
        try {
            this.getPool().stop();
        }
        catch (Exception e) {
            Reporter.get().reportError(Msg.getString("PoolDevice.reporter.title", new Object[0]), Msg.getString("PoolDevice.errorFailedStopping", new Object[]{this.getId()}), (Throwable)e, 0);
        }
    }

    protected void basicOnContextRefreshed() {
        super.basicOnContextRefreshed();
        if (this.getPool().isAutoStart()) {
            try {
                this.getPool().start();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    protected Object controlBasic(String command, IArgs args) throws ApplicationException {
        switch (command) {
            case "start": {
                this.controlStart();
                break;
            }
            case "stop": {
                this.controlStop();
                break;
            }
            case "suspend": {
                this.controlSuspend();
                break;
            }
            case "resume": {
                this.controlResume();
                break;
            }
            case "toggleSuspend": {
                if (this.getPool().isSuspended()) {
                    this.controlResume();
                    break;
                }
                this.controlSuspend();
                break;
            }
            default: {
                return super.controlBasic(command, args);
            }
        }
        return null;
    }

    protected void controlResume() {
        this.getPool().resume();
    }

    protected void controlStart() {
        this.getPool().start();
    }

    protected void controlStop() {
        this.getPool().stop();
    }

    protected void controlSuspend() {
        this.getPool().suspend();
    }

    protected CommonDeviceHealth createHealth() {
        return new PoolDeviceHealth();
    }

    protected void createHealthProperties(CommonDeviceHealth health) {
        super.createHealthProperties(health);
        ((PoolDeviceHealth)health).setEntryCount(this.getPool().getEntryCount());
        ((PoolDeviceHealth)health).setMaxEntryCount(this.getPool().getMaxEntryCount());
        ((PoolDeviceHealth)health).setActiveEntryCount(this.getPool().getActiveEntryCount());
        ((PoolDeviceHealth)health).setMaxActiveEntryCount(this.getPool().getMaxActiveEntryCount());
        ((PoolDeviceHealth)health).setLicensedActiveEntryCount(this.getPool().getLicensedActiveEntryCount());
        ((PoolDeviceHealth)health).setPending(this.getPool().getPending());
        ((PoolDeviceHealth)health).setRunState(this.getPool().getState());
    }

    public PoolPrincipal createPrincipal(IX509Certificate certificate) {
        return this.createPrincipal(certificate, true);
    }

    protected PoolPrincipal createPrincipal(IX509Certificate certificate, boolean owner) {
        PoolPrincipal principal = (PoolPrincipal)((Object)certificate.getAttribute((Object)this.ATTR_PRINCIPAL));
        if (principal == null) {
            if (certificate instanceof IX509PublicKeyCertificate) {
                principal = new PoolPrincipal((IDevice)this, (IX509PublicKeyCertificate)certificate);
                principal.setKeyOwner(owner);
            }
            certificate.setAttribute((Object)this.ATTR_PRINCIPAL, (Object)principal);
        }
        return principal;
    }

    protected void ensurePrincipalsAvailable() {
        ArrayList<PoolPrincipal> list = new ArrayList<PoolPrincipal>();
        List entries = this.getPool().getEntries();
        for (PoolEntry entry : entries) {
            IX509PublicKeyCertificate cert;
            PoolPrincipal principal;
            Object app = entry.getSecurityApplication();
            if (!(app instanceof ISigner) || (principal = this.createPrincipal((IX509Certificate)(cert = ((ISigner)app).getCertificatePath()[0]), true)) == null) continue;
            list.add(principal);
        }
        this.setPrincipals(list);
    }

    public GenericPool<ISecurityApplication> getPool() {
        return this.pool;
    }

    public IPoolListener getPoolListener() {
        return this.poolListener;
    }

    protected void initBasic() throws Exception {
        super.initBasic();
        this.getPool().setPoolListener(this.getPoolListener());
    }

    protected NotificationBroadcasterSupport mbeanCreate() {
        return new JmxPoolDevice(this);
    }

    public void preferencesRestore() {
        IPreferences prefDevice = this.getPreferences();
        IPreferences prefPool = prefDevice.node("pool");
        this.getPool().preferencesRestore(prefPool);
        this.getPoolListener().preferencesRestore(prefDevice);
    }

    public void preferencesStore() {
        IPreferences prefDevice = this.getPreferences();
        IPreferences prefPool = prefDevice.node("pool");
        this.getPool().preferencesStore(prefPool);
        this.getPoolListener().preferencesStore(prefDevice);
        try {
            prefDevice.flush();
        }
        catch (BackingStoreException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    protected void setPool(GenericPool<ISecurityApplication> pool) {
        if (this.pool != null) {
            pool.removeNotificationListener(EventType.ALWAYS, this.poolNotificationListener);
        }
        this.pool = pool;
        if (this.pool != null) {
            pool.addNotificationListener(EventType.ALWAYS, this.poolNotificationListener);
        }
    }

    public void setPoolListener(IPoolListener poolListener) {
        this.poolListener = poolListener;
    }
}

