/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.device;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.common.CommonDeviceFactoryBean;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.device.PoolDeviceProvider;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;

public abstract class PoolDeviceFactoryBean
extends CommonDeviceFactoryBean<PoolDevice> {
    private boolean autostart;
    private String typeDescription;
    private long timeout = -1L;
    private int notificationPercentage = 10;
    private long maxUptime = -1L;
    private int maxUsageCount = -1;
    private int maxEntryCount = -1;
    private int maxActiveEntryCount = -1;
    private int reportingFlags = 2;
    private GenericPool pool;
    private IPoolListener<?> poolListener;

    public static PoolDeviceFactoryBean createBuilder(Object optionValue) throws ObjectCreationException {
        if (optionValue == null) {
            return null;
        }
        if (optionValue instanceof PoolDeviceFactoryBean) {
            return (PoolDeviceFactoryBean)((Object)optionValue);
        }
        if (optionValue instanceof Class) {
            return (PoolDeviceFactoryBean)((Object)ObjectTools.createObject((Class)((Class)optionValue), PoolDeviceFactoryBean.class));
        }
        if (optionValue instanceof String) {
            return (PoolDeviceFactoryBean)((Object)ObjectTools.createObject((String)((String)optionValue), PoolDeviceFactoryBean.class, null));
        }
        throw new ObjectCreationException("cannot create PoolConfiguration from " + optionValue);
    }

    public static PoolDeviceFactoryBean getBuilder(IArgs args, String name) throws ObjectCreationException {
        if (args == null) {
            return null;
        }
        Object optionValue = ArgTools.getPath((IArgs)args, (String)name);
        return PoolDeviceFactoryBean.createBuilder(optionValue);
    }

    protected CommonDeviceProvider createDeviceProvider() {
        return (CommonDeviceProvider)DeviceTools.lookupDeviceProvider(PoolDeviceProvider.class);
    }

    protected PoolDevice createInstance() throws Exception {
        CommonDeviceProvider provider = this.getDeviceProviderOrDefault();
        if (provider == null) {
            throw new ObjectCreationException("cannot create pool device '" + this.getId() + "', pool device provider missing");
        }
        this.pool = this.createPool();
        this.poolListener = this.createPoolListener(this.pool);
        Args args = Args.create();
        args.put("id", (Object)this.pool.getId());
        args.put("pool", (Object)this.pool);
        args.put("poolListener", this.poolListener);
        PoolDevice device = (PoolDevice)provider.createInstance((IArgs)args);
        device.preferencesRestore();
        return device;
    }

    protected final GenericPool createPool() throws ObjectCreationException {
        GenericPool<ISecurityApplication> pool = this.createPoolObject();
        pool.setId(this.getId());
        pool.setAutoStart(this.isAutostart());
        pool.setTimeout(this.getTimeout());
        pool.setNotificationPercentage(this.getNotificationPercentage());
        pool.setMaxUptimeMinutes(this.getMaxUptime());
        pool.setMaxUsageCount(this.getMaxUsageCount());
        pool.setMaxEntryCount(this.getMaxEntryCount());
        pool.setMaxActiveEntryCount(this.getMaxActiveEntryCount());
        pool.setReportingFlags(this.getReportingFlags());
        pool.setTypeDescription(this.getTypeDescription());
        return pool;
    }

    protected abstract IPoolListener createPoolListener(GenericPool var1) throws ObjectCreationException;

    protected GenericPool<ISecurityApplication> createPoolObject() {
        return new GenericPool<ISecurityApplication>();
    }

    public int getMaxActiveEntryCount() {
        return this.maxActiveEntryCount;
    }

    public int getMaxEntryCount() {
        return this.maxEntryCount;
    }

    public long getMaxUptime() {
        return this.maxUptime;
    }

    public int getMaxUsageCount() {
        return this.maxUsageCount;
    }

    public int getNotificationPercentage() {
        return this.notificationPercentage;
    }

    public Class<?> getObjectType() {
        return PoolDevice.class;
    }

    protected GenericPool getPool() {
        return this.pool;
    }

    protected IPoolListener<?> getPoolListener() {
        return this.poolListener;
    }

    public int getReportingFlags() {
        return this.reportingFlags;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public boolean isAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    public void setMaxActiveEntryCount(int maxActiveEntryCount) {
        this.maxActiveEntryCount = maxActiveEntryCount;
    }

    public void setMaxEntryCount(int maxPoolSize) {
        this.maxEntryCount = maxPoolSize;
    }

    public void setMaxUptime(long maxUptime) {
        this.maxUptime = maxUptime;
    }

    public void setMaxUsageCount(int maxUsageCount) {
        this.maxUsageCount = maxUsageCount;
    }

    public void setNotificationPercentage(int notificationPercentage) {
        this.notificationPercentage = notificationPercentage;
    }

    public void setReportingFlags(int reportingFlags) {
        this.reportingFlags = reportingFlags;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }
}

