/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pool.app.PoolSignerFactory;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class PoolDeviceProvider
extends CommonDeviceProvider<PoolDevice> {
    private final CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);

    public PoolDeviceProvider() {
        super("pool");
    }

    protected PoolDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        PoolDevice device = new PoolDevice(this, this.getId(args));
        device.setPool((GenericPool)ArgTools.getObject((IArgs)args, (String)"pool", null));
        device.setPoolListener((IPoolListener)ArgTools.getObject((IArgs)args, (String)"poolListener", null));
        return device;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        PoolSignerFactory descriptor = new PoolSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)this.signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.pool");
    }

    @PostConstruct
    public void init() {
        super.init();
        IElement policyElement = ElementTools.getPathElement((IElement)this.getConfiguration(), (String[])new String[]{"policies", "signer"});
        if (policyElement != null) {
            try {
                this.signerPolicy.configure(policyElement);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

