/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.device;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.pool.device.PACKAGE;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.device.PoolDeviceProvider;
import de.intarsys.security.device.pool.impl.CommonPool;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PoolTools {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static <S extends ISecurityApplication> CommonPool<S> copyPool(CommonPool<S> object) {
        try {
            IElement tempElement = ElementFactory.get().createElement("container");
            IDocument tempDocument = ElementFactory.get().createDocument();
            ((IStringEvaluatorAccess)tempDocument).setStringEvaluator(ExpressionEvaluator.get((Mode)Mode.UNTRUSTED));
            tempDocument.setRootElement(tempElement);
            object.serialize(tempElement);
            tempElement.setAttributeValue("id", null);
            CommonPool copy = (CommonPool)ElementTools.createObject((IElement)tempElement, CommonPool.class, (Object)object.getClass().getClassLoader(), (IArgs)Args.create());
            copy.setPersistent(false);
            String baseId = Msg.getString("PoolTools.copyPrefix", new Object[0]) + " " + object.getId();
            copy.setId(PoolTools.createPoolId(baseId));
            return copy;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createPoolId(String baseId) {
        if (StringTools.isEmpty((String)baseId)) {
            baseId = Msg.getString("PoolTools.newPool.label", new Object[0]);
        }
        Object id = baseId;
        int index = 2;
        while (PoolTools.isPoolIdUsed((String)id)) {
            id = baseId + " " + index++;
        }
        return id;
    }

    public static List<IPool> getPools() {
        ArrayList<IPool> pools = new ArrayList<IPool>();
        for (PoolDeviceProvider provider : DeviceTools.lookupDeviceProviders(PoolDeviceProvider.class)) {
            Iterator iterator = provider.iterator();
            while (iterator.hasNext()) {
                PoolDevice device = (PoolDevice)((Object)iterator.next());
                pools.add(device.getPool());
            }
        }
        return pools;
    }

    public static boolean isPoolIdUsed(String id) {
        return PoolTools.lookupPool(id) != null;
    }

    public static IPool lookupPool(String id) {
        for (PoolDeviceProvider provider : DeviceTools.lookupDeviceProviders(PoolDeviceProvider.class)) {
            Iterator iterator = provider.iterator();
            while (iterator.hasNext()) {
                PoolDevice device = (PoolDevice)((Object)iterator.next());
                if (!id.equals(device.getId())) continue;
                return device.getPool();
            }
        }
        return null;
    }

    private PoolTools() {
    }
}

