/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.impl;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.PACKAGE;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.security.device.pool.impl.PoolResourceNotAvailable;
import de.intarsys.security.device.pool.impl.PoolStopped;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IIdentifiable;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.ResumedEvent;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.event.SuspendedEvent;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.notice.NoticeEvent;
import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReplayReporter;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonPool<T extends ISecurityApplication>
implements IPool<PoolEntry<T>>,
IIdentifiable,
IStartStop,
INotificationSupport,
IElementConfigurable,
IContextSupport,
IElementSerializable,
IPresentationSupport,
IReporterSupport,
IReporter {
    public static final String EA_REPORTING_FLAGS = "reportingFlags";
    public static final String EA_MAX_ACTIVE = "maxActive";
    public static final String EA_MAX_POOL_SIZE = "maxPoolSize";
    public static final String ATTR_TIMEOUT = "timeout";
    public static final String ATTR_NOTIFICATION_PERCENTAGE = "notificationPercentage";
    public static final String EE_PASSWORD_PROVIDER = "passwordProvider";
    public static final String EA_TIMEOUT = "timeout";
    public static final String EA_MAX_USAGE_COUNT = "maxUsageCount";
    public static final String EA_MAX_UPTIME = "maxUptime";
    public static final String EA_MAX_ENTRY_COUNT = "maxEntryCount";
    public static final String EA_MAX_ACTIVE_ENTRY_COUNT = "maxActiveEntryCount";
    public static final String EA_NOTIFICATION_PERCENTAGE = "notificationPercentage";
    public static final String EA_AUTOSTART = "autostart";
    public static final String EA_ID = "id";
    public static final String EA_CLASS = "class";
    public static final String NOTIFY_TARGET_SUSPENDED = "target.suspended";
    public static final String NOTIFY_TARGET_RESUMED = "target.resumed";
    public static final String NOTIFY_TARGET_ERROR = "target.error";
    public static final String NOTIFY_TARGET_NO_DEVICE = "target.noDevice";
    public static final String NOTIFY_TARGET_STOPPED = "target.stopped";
    public static final String NOTIFY_TARGET_STARTED = "target.started";
    public static final int DEFAULT_TIMEOUT = -1;
    private static final Logger Log = LoggerFactory.getLogger(CommonPool.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String LICPROP_DIGESTSIGNERPOOL_MAXACTIVE = "digestsignerpool_maxactivedevices";
    public static final String LICPROP_DIGESTSIGNERPOOL_MAXSIZE = "digestsignerpool_maxpoolsize";
    public static final String NOTIFY_DEVICE_LIMIT_WARN = "device.limitWarn";
    public static final String NOTIFY_DEVICE_LIMIT_REACHED = "device.limitReached";
    public static final String NOTIFY_DEVICE_AUTHENTICATION_FINISHED = "device.authenticationFinished";
    public static final String NOTIFY_DEVICE_AUTHENTICATION_REQUIRED = "device.authenticationRequired";
    public static final String NOTIFY_DEVICE_AUTHENTICATION_FAILED = "device.authenticationFailed";
    protected static boolean LicenseCheck = true;
    private int activeEntryCount = 0;
    private boolean autoStart = false;
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private ScheduledExecutorService cleanupExecutor;
    private long cleanupInterval = 60000L;
    private final LinkedList<PoolEntry<T>> entries = new LinkedList();
    private final LinkedList<PoolEntry<T>> unusedEntries = new LinkedList();
    private final Runnable housekeepingCommand = new Runnable(){

        @Override
        public void run() {
            CommonPool.this.housekeeping();
        }
    };
    private String id;
    protected final Object lock = new Object();
    private int effectiveMaxActiveEntries = 1;
    private int maxActiveEntryCount = -1;
    private int maxEntryCount = -1;
    private long maxUptime = -1L;
    private int maxUsageCount = -1;
    private int pending = 0;
    private boolean persistent = true;
    private final ReplayReporter reporter = new ReplayReporter((Object)this);
    private int reportingFlags = 2;
    private boolean started = false;
    private long startTime = 0L;
    private boolean suspended = false;
    private long timeout = -1L;
    private int totalCheckoutTasks = 0;
    private long totalCheckoutTime = 0L;
    private int notificationPercentage = 10;
    private Object context;
    private String JMX_TYPE = "pool";

    protected CommonPool() {
    }

    protected void acquireResources() {
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    public void addReporter(IReporter newReporter) {
        this.reporter.addReporter(newReporter);
    }

    protected void basicResume() {
    }

    protected void basicResumeNotify() {
        ResumedEvent event = new ResumedEvent((Object)this);
        this.triggerEvent((Event)event);
        this.triggerChanged("state", null, null);
        String msg = Msg.getString("CommonPool.StateResumed", new Object[]{this.getLabel()});
        this.reportStatus(msg, 0);
    }

    protected void basicStart() {
        this.setActiveEntryCount(0);
        this.startTime = System.currentTimeMillis();
        this.totalCheckoutTasks = 0;
        this.totalCheckoutTime = 0L;
    }

    protected void basicStartNotify() {
        Log.info("{} started", (Object)this.getLogLabel());
        StartedEvent event = new StartedEvent((Object)this);
        this.triggerEvent((Event)event);
        this.triggerChanged("state", null, null);
        String msg = Msg.getString("CommonPool.StateStarted", new Object[]{this.getLabel()});
        this.reportStatus(msg, 0);
    }

    protected void basicStop() {
        this.startTime = 0L;
    }

    protected void basicStopNotify() {
        Log.info("{} stopped", (Object)this.getLogLabel());
        StoppedEvent event = new StoppedEvent((Object)this);
        this.triggerEvent((Event)event);
        this.triggerChanged("state", null, null);
        String msg = Msg.getString("CommonPool.StateStopped", new Object[]{this.getLabel()});
        this.reportStatus(msg, 0);
    }

    protected boolean basicStopRequested(Set visited) {
        return true;
    }

    protected void basicSuspend() {
    }

    protected void basicSuspendNotify() {
        SuspendedEvent event = new SuspendedEvent((Object)this);
        this.triggerEvent((Event)event);
        this.triggerChanged("state", null, null);
        String msg = Msg.getString("CommonPool.StateSuspended", new Object[]{this.getLabel()});
        this.reportStatus(msg, 0);
    }

    protected void checkEntries() {
        Log.debug("{} check entries", (Object)this.getLogLabel());
        List<PoolEntry<T>> tempEntries = this.getEntries();
        for (PoolEntry<T> entry : tempEntries) {
            if (this.entryCheck(entry)) continue;
            this.entriesRemove(entry, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkin(PoolEntry<T> entry) throws Exception {
        Log.debug("{} checkin entry {}", (Object)this.getLogLabel(), entry);
        boolean remove = true;
        boolean retry = false;
        Object object = this.lock;
        synchronized (object) {
            this.setActiveEntryCount(this.getActiveEntryCount() - 1);
            entry.setActive(false);
            this.unusedEntries.add(entry);
            ++this.totalCheckoutTasks;
            this.totalCheckoutTime += System.currentTimeMillis() - entry.getActivated();
            if (this.isStarted()) {
                if (this.entryCheck(entry)) {
                    remove = false;
                    this.lock.notifyAll();
                } else {
                    retry = true;
                }
            }
        }
        entry.checkNotification();
        if (remove) {
            this.entriesRemove(entry, retry);
        } else {
            Log.trace("{} checked in entry {}", (Object)this.getLogLabel(), entry);
        }
    }

    protected void checkLicenseActivePoolCount() {
        int limitPoolSize = this.getLicensedActivePoolCount();
        if (limitPoolSize != -1 && limitPoolSize <= GenericPool.getActivePoolCount()) {
            String title = Msg.getString("CommonPool.report.title", new Object[0]);
            String msg = Msg.getString("CommonPool.reportLimitActivePoolCount", new Object[]{this.getLabel(), limitPoolSize});
            this.reportError(title, msg, null, 0);
            throw new LicenseException(msg);
        }
    }

    protected void checkLicensedActiveEntries() {
        int limitMaxActive = this.getLicensedActiveEntryCount();
        if (limitMaxActive != -1 && (-1 == this.getMaxActiveEntryCount() || limitMaxActive < this.getMaxActiveEntryCount())) {
            this.setEffectiveMaxActiveEntries(limitMaxActive);
            Log.warn("{} maxActiveEntries {} exceeds licensedActiveEntries {}", new Object[]{this.getLogLabel(), this.getMaxActiveEntryCount(), this.getLicensedActiveEntryCount()});
        } else {
            this.setEffectiveMaxActiveEntries(this.getMaxActiveEntryCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PoolEntry<T> checkout(long pTimeout) throws Exception {
        Log.debug("{} checkout", (Object)this.getLogLabel());
        if (pTimeout == -1L) {
            pTimeout = this.getTimeout();
        } else if (this.getTimeout() != -1L) {
            pTimeout = Math.min(pTimeout, this.getTimeout());
        }
        long startWaitTime = System.currentTimeMillis();
        try {
            Object object = this.lock;
            synchronized (object) {
                while (this.isStarted()) {
                    PoolEntry<T> entry;
                    if (this.isStarted() && !this.isSuspended() && (this.getEffectiveMaxActiveEntries() == -1 || this.getActiveEntryCount() < this.getEffectiveMaxActiveEntries()) && (entry = this.unusedEntries.poll()) != null && this.entryCheck(entry)) {
                        this.setActiveEntryCount(this.getActiveEntryCount() + 1);
                        entry.setActive(true);
                        Log.debug("{} checked out entry {}", (Object)this.getLogLabel(), entry);
                        return entry;
                    }
                    this.checkoutWait(pTimeout, startWaitTime);
                }
            }
        }
        catch (PoolResourceNotAvailable e) {
            this.triggerEvent((Event)new NoticeEvent((Object)this, e.getNotice()));
            throw e;
        }
        String msg = Msg.getString("CommonPool.errorStopped", new Object[]{this.getLabel()});
        throw new PoolStopped(msg);
    }

    protected void checkoutWait(long pTimeout, long startWaitTime) throws PoolResourceNotAvailable, PoolStopped {
        block7: {
            this.setPending(this.getPending() + 1);
            try {
                if (pTimeout == -1L) {
                    Log.debug("{} checkout wait indefinitely", (Object)this.getLogLabel());
                    this.lock.wait();
                    break block7;
                }
                if ((pTimeout = pTimeout - System.currentTimeMillis() + startWaitTime) > 0L) {
                    Log.debug("{} checkout wait {}", (Object)this.getLogLabel(), (Object)pTimeout);
                    this.lock.wait(pTimeout);
                    break block7;
                }
                Notice notice = new Notice(Msg, 30, false, "pool.resourceNotAvailable", new Object[]{this.getLabel()});
                throw new PoolResourceNotAvailable(notice.getString(), (INotice)notice);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                String msg = Msg.getString("CommonPool.errorStopped", new Object[]{this.getLabel()});
                throw new PoolStopped(msg);
            }
            finally {
                this.setPending(this.getPending() - 1);
            }
        }
    }

    public void close() throws Exception {
        this.stop();
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setId(element.attributeValue(EA_ID, null));
        this.setAutoStart(ElementTools.getBoolean((IElement)element, (String)EA_AUTOSTART, (boolean)this.isAutoStart()));
        this.setTimeout(ElementTools.getInt((IElement)element, (String)"timeout", (int)((int)this.getTimeout())));
        this.setNotificationPercentage(ElementTools.getInt((IElement)element, (String)"notificationPercentage", (int)this.getNotificationPercentage()));
        this.setMaxUptimeMinutes(ElementTools.getInt((IElement)element, (String)EA_MAX_UPTIME, (int)((int)this.getMaxUptime())));
        this.setMaxUsageCount(ElementTools.getInt((IElement)element, (String)EA_MAX_USAGE_COUNT, (int)this.getMaxUsageCount()));
        this.setMaxEntryCount(ElementTools.getInt((IElement)element, (String)EA_MAX_POOL_SIZE, (int)this.getMaxEntryCount()));
        this.setMaxEntryCount(ElementTools.getInt((IElement)element, (String)EA_MAX_ENTRY_COUNT, (int)this.getMaxEntryCount()));
        this.setMaxActiveEntryCount(ElementTools.getInt((IElement)element, (String)EA_MAX_ACTIVE, (int)this.getMaxActiveEntryCount()));
        this.setMaxActiveEntryCount(ElementTools.getInt((IElement)element, (String)EA_MAX_ACTIVE_ENTRY_COUNT, (int)this.getMaxActiveEntryCount()));
        this.setReportingFlags(ElementTools.getInt((IElement)element, (String)EA_REPORTING_FLAGS, (int)2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(PoolEntry<T> object) throws Exception {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("{}  destroy {}", (Object)this.getLogLabel(), (Object)StringTools.safeString(object));
        }
        PoolEntry<T> entry = object;
        Object object2 = this.lock;
        synchronized (object2) {
            if (entry.isActive()) {
                this.setActiveEntryCount(this.getActiveEntryCount() - 1);
                entry.setActive(false);
            }
        }
        this.entriesRemove(entry, false);
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("{} destroyed {}", (Object)this.getLogLabel(), (Object)StringTools.safeString(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entriesAdd(PoolEntry<T> entry) {
        Log.debug("{} add entry {}", (Object)this.getLogLabel(), entry);
        boolean destroy = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStarted() || this.getMaxEntryCount() != -1 && this.getEntryCount() >= this.getMaxEntryCount()) {
                destroy = true;
            } else {
                destroy = false;
                this.entries.add(entry);
                if (!entry.isActive()) {
                    this.unusedEntries.add(entry);
                }
                this.startCleanup();
                if (this.cleanupExecutor != null && this.getMaxUptime() != -1L) {
                    this.cleanupExecutor.schedule(this.housekeepingCommand, this.getMaxUptime(), TimeUnit.MILLISECONDS);
                }
                this.lock.notifyAll();
            }
        }
        if (destroy) {
            this.entryDispose(entry);
        } else {
            IMessage msg = Msg.getMessage("pool.entryAdded", new Object[]{this.getLabel(), entry.getLabel()});
            this.reportMessage("", msg.getString(), 0);
            this.triggerChanged("entries", null, entry);
            this.triggerEvent((Event)new NoticeEvent((Object)this, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entriesRemove(PoolEntry<T> entry, boolean retry) {
        this.entryDispose(entry);
        Log.info("{} remove entry {}", (Object)this.getLogLabel(), entry);
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            this.unusedEntries.remove(entry);
            removed = this.entries.remove(entry);
            if (removed) {
                if (this.entries.isEmpty()) {
                    this.stopCleanup();
                }
                this.lock.notifyAll();
            }
        }
        if (removed) {
            IMessage msg = Msg.getMessage("pool.entryRemoved", new Object[]{this.getLabel(), entry.getLabel()});
            this.reportMessage("", msg.getString(), 0);
            this.triggerChanged("entries", entry, null);
            this.triggerEvent((Event)new NoticeEvent((Object)this, msg));
        }
    }

    protected boolean entryCheck(PoolEntry<T> entry) {
        return entry.isValid();
    }

    protected void entryDispose(PoolEntry<T> entry) {
        Log.info("{} dispose entry {}", (Object)this.getLogLabel(), entry);
        entry.setActive(false);
        entry.dispose();
    }

    protected boolean fromEntryCheck(PoolEntry<T> entry) {
        return this.entryCheck(entry);
    }

    protected void fromEntryNotification(PoolEntry<T> entry, String type, String message) {
        this.triggerEvent((Event)new NoticeEvent((Object)this, type, message, new Object[0]));
    }

    protected void fromEntryRelease(PoolEntry<T> entry) throws Exception {
        this.checkin(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveEntryCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.activeEntryCount;
        }
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public Object getContext() {
        return this.context;
    }

    public String getDescription() {
        return this.getTypeDescription() + " '" + this.getLabel() + "' [" + this.getId() + "]";
    }

    protected int getEffectiveMaxActiveEntries() {
        return this.effectiveMaxActiveEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PoolEntry<T>> getEntries() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<PoolEntry<T>>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.entries.size();
        }
    }

    public String getIconName() {
        Object iconName = this.isStarted() ? (this.isSuspended() ? "digestsignerpool/pause" : "digestsignerpool/run") : "digestsignerpool/stop";
        if (this.getPending() > 0) {
            iconName = (String)iconName + "+digestsignerpool/warning";
        }
        return iconName;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.getId();
    }

    public int getLicensedActiveEntryCount() {
        int result = 1;
        LicenseProperty property = LicenseEnvironment.get().getLicensePropertyMaxGlobal(LICPROP_DIGESTSIGNERPOOL_MAXACTIVE);
        if (property != null) {
            result = property.getValueInt();
        }
        return result;
    }

    public int getLicensedActivePoolCount() {
        if (!LicenseCheck) {
            return -1;
        }
        int result = 0;
        LicenseProperty property = LicenseEnvironment.get().getLicensePropertyMaxGlobal(LICPROP_DIGESTSIGNERPOOL_MAXSIZE);
        if (property != null) {
            result = property.getValueInt();
        }
        return result;
    }

    public String getLogLabel() {
        return "security application pool '" + this.getId() + "'";
    }

    public int getMaxActiveEntryCount() {
        return this.maxActiveEntryCount;
    }

    public int getMaxEntryCount() {
        return this.maxEntryCount;
    }

    public long getMaxUptime() {
        return this.maxUptime;
    }

    public int getMaxUptimeMinutes() {
        if (this.maxUptime < 0L) {
            return (int)this.maxUptime;
        }
        return (int)(this.maxUptime / 60L / 1000L);
    }

    public int getMaxUsageCount() {
        return this.maxUsageCount;
    }

    public int getMeanCheckoutTime() {
        long time = this.getTotalCheckoutTime();
        int count = this.getTotalCheckoutTasks();
        if (count == 0) {
            return 0;
        }
        return (int)(time / (long)count);
    }

    public int getNotificationPercentage() {
        return this.notificationPercentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPending() {
        Object object = this.lock;
        synchronized (object) {
            return this.pending;
        }
    }

    public int getReportingFlags() {
        return this.reportingFlags;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getState() {
        if (this.isStarted()) {
            if (this.isSuspended()) {
                return "suspended";
            }
            return "started";
        }
        return "stopped";
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getTip() {
        return this.getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCheckoutTasks() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalCheckoutTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalCheckoutTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalCheckoutTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalUpTime() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStarted()) {
                return 0L;
            }
            return System.currentTimeMillis() - this.getStartTime();
        }
    }

    protected String getTypeDescription() {
        return "Pool";
    }

    public void housekeeping() {
        this.checkEntries();
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Object object = this.lock;
        synchronized (object) {
            return this.suspended;
        }
    }

    protected void onStartAfter() {
    }

    protected void onStartBefore() {
    }

    protected void onStopAfter() {
    }

    protected void onStopBefore() {
    }

    public void refresh() {
    }

    protected void releaseEntries() {
        Log.debug("{} release pooled entries", (Object)this.getLogLabel());
        List<PoolEntry<T>> tempEntries = this.getEntries();
        for (PoolEntry<T> entry : tempEntries) {
            this.entriesRemove(entry, false);
        }
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void removeReporter(IReporter newReporter) {
        this.reporter.removeReporter(newReporter);
    }

    public IProgressMonitor reportActivityStart(IMessage activity, int style) {
        return this.reporter.reportActivityStart(activity, style);
    }

    public void reportError(String title, String message, Throwable t, int style) {
        String msg = "Pool '" + this.getId() + "' error (" + message + ")";
        Notice notice = new Notice(30, false, "error", msg, new Object[0]);
        this.triggerEvent((Event)new NoticeEvent((Object)this, (INotice)notice));
        this.reporter.reportError(title, message, t, style);
    }

    public void reportMessage(String title, String message, int style) {
        this.reporter.reportMessage(title, message, style);
    }

    public void reportStatus(String message, int style) {
        this.reporter.reportStatus(message, style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            if (!this.started || !this.suspended) {
                return;
            }
            this.basicResume();
            this.suspended = false;
        }
        this.basicResumeNotify();
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setName(this.JMX_TYPE);
        element.setAttributeValue(EA_CLASS, this.getClass().getName());
        element.setAttributeValue(EA_ID, this.getId());
        element.setAttributeValue(EA_AUTOSTART, String.valueOf(this.isAutoStart()));
        element.setAttributeValue("notificationPercentage", String.valueOf(this.getNotificationPercentage()));
        element.setAttributeValue(EA_MAX_ACTIVE_ENTRY_COUNT, String.valueOf(this.getMaxActiveEntryCount()));
        element.setAttributeValue(EA_MAX_ENTRY_COUNT, String.valueOf(this.getMaxEntryCount()));
        element.setAttributeValue(EA_MAX_UPTIME, String.valueOf(this.getMaxUptimeMinutes()));
        element.setAttributeValue(EA_MAX_USAGE_COUNT, String.valueOf(this.getMaxUsageCount()));
        element.setAttributeValue("timeout", String.valueOf(this.getTimeout()));
    }

    protected void setActiveEntryCount(int active) {
        Integer oldValue = this.activeEntryCount;
        this.activeEntryCount = active;
        this.triggerChangedDeferred("active", oldValue, active);
    }

    public void setAutoStart(boolean autoStart) {
        Boolean oldValue = this.autoStart;
        this.autoStart = autoStart;
        this.triggerChanged("autoStart", oldValue, autoStart);
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    protected void setEffectiveMaxActiveEntries(int effectiveMaxActiveEntryCount) {
        this.effectiveMaxActiveEntries = effectiveMaxActiveEntryCount;
    }

    public void setId(String id) {
        String oldValue = this.id;
        this.id = id;
        this.triggerChanged(EA_ID, oldValue, id);
    }

    public void setMaxActiveEntryCount(int maxActive) {
        if (maxActive < -1) {
            Log.warn("{} maxActive less than -1", (Object)this.getLogLabel());
            maxActive = -1;
        }
        if (maxActive == 0) {
            Log.warn("{} maxActive == 0", (Object)this.getLogLabel());
            maxActive = 1;
        }
        Integer oldValue = this.maxActiveEntryCount;
        this.maxActiveEntryCount = maxActive;
        this.triggerChanged(EA_MAX_ACTIVE, oldValue, maxActive);
    }

    public void setMaxEntryCount(int maxEntryCount) {
        if (maxEntryCount < -1) {
            Log.warn("{} maxEntryCount less than -1", (Object)this.getLogLabel());
            maxEntryCount = -1;
        }
        if (maxEntryCount == 0) {
            Log.warn("{} maxEntryCount == 0", (Object)this.getLogLabel());
            maxEntryCount = 1;
        }
        Integer oldValue = this.maxEntryCount;
        this.maxEntryCount = maxEntryCount;
        this.triggerChanged(EA_MAX_POOL_SIZE, oldValue, maxEntryCount);
    }

    public void setMaxUptime(long maxUptime) {
        Long oldValue = this.maxUptime;
        this.maxUptime = maxUptime;
        this.triggerChanged(EA_MAX_UPTIME, oldValue, maxUptime);
    }

    public void setMaxUptimeMinutes(long maxUptimeMinutes) {
        Long oldValue = this.maxUptime;
        this.maxUptime = maxUptimeMinutes < 0L ? maxUptimeMinutes : maxUptimeMinutes * 60L * 1000L;
        this.triggerChanged(EA_MAX_UPTIME, oldValue, this.maxUptime);
    }

    public void setMaxUsageCount(int maxUsageCount) {
        Integer oldValue = this.maxUsageCount;
        this.maxUsageCount = maxUsageCount;
        this.triggerChanged(EA_MAX_USAGE_COUNT, oldValue, maxUsageCount);
    }

    public void setNotificationPercentage(int notificationPercentage) {
        Integer oldValue = this.notificationPercentage;
        this.notificationPercentage = notificationPercentage;
        this.triggerChanged("notificationPercentage", oldValue, notificationPercentage);
    }

    protected void setPending(int pPending) {
        Integer oldValue = this.pending;
        this.pending = pPending;
        this.triggerChangedDeferred("pending", oldValue, this.pending);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setReportingFlags(int reportingFlags) {
        this.reportingFlags = reportingFlags;
    }

    public void setTimeout(long timeout) {
        Long oldValue = this.timeout;
        this.timeout = timeout;
        this.triggerChanged("timeout", oldValue, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.onStartBefore();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            if (this.started) {
                return;
            }
            this.acquireResources();
            this.basicStart();
            this.started = true;
            this.suspended = false;
        }
        this.onStartAfter();
        this.basicStartNotify();
    }

    protected void startCleanup() {
        if (this.cleanupExecutor != null) {
            return;
        }
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon((String)"pool reaper"));
        this.cleanupExecutor.scheduleWithFixedDelay(this.housekeepingCommand, this.cleanupInterval, this.cleanupInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.onStopBefore();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            if (!this.started) {
                return;
            }
            this.basicStop();
            this.started = false;
        }
        this.onStopAfter();
        this.releaseEntries();
        this.basicStopNotify();
    }

    protected void stopCleanup() {
        if (this.cleanupExecutor == null) {
            return;
        }
        this.cleanupExecutor.shutdown();
        this.cleanupExecutor = null;
    }

    public final boolean stopRequested(Set visited) {
        if (visited != null) {
            if (visited.contains(this)) {
                return true;
            }
            visited.add(this);
        }
        return this.basicStopRequested(visited);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            if (!this.started || this.suspended) {
                return;
            }
            this.basicSuspend();
            this.suspended = true;
        }
        this.basicSuspendNotify();
    }

    public String toString() {
        return "security application pool '" + this.getLabel() + "'";
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerChangedDeferred(Object attribute, Object oldValue, Object newValue) {
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Log.error("{} unexpected exception in CommonPool.triggerEvent", (Object)this.getLogLabel(), (Object)e);
        }
    }
}

