/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.impl;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.IElementSerializationHandler;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reflect.ObjectCreationException;

public abstract class CommonPoolListener<T extends ISecurityApplication>
implements IPoolListener<T>,
IElementConfigurable,
IElementSerializable {
    private final GenericPool<T> pool;
    private Secret pin;
    private IPasswordProvider passwordProvider;
    private IX509CertificateFilter certificateFilter;

    public CommonPoolListener(GenericPool<T> pool) {
        this.pool = pool;
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            IElement certificateFilterElement = element.element("certificateFilter");
            if (certificateFilterElement != null) {
                this.setCertificateFilter((IX509CertificateFilter)ElementTools.createObject((IElement)certificateFilterElement, IX509CertificateFilter.class, (Object)this.getContext(), (IArgs)Args.create()));
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public IX509CertificateFilter getCertificateFilter() {
        return this.certificateFilter;
    }

    public Object getContext() {
        return null;
    }

    protected Object getLogLabel() {
        return this.pool == null ? this.toString() : this.getPool().getLogLabel();
    }

    public IPasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public Secret getPin() {
        return this.pin;
    }

    public GenericPool<T> getPool() {
        return this.pool;
    }

    @Override
    public void preferencesRestore(IPreferences prefs) {
    }

    @Override
    public void preferencesStore(IPreferences prefs) {
    }

    @Override
    public void retry(GenericPool<T> genericPool, PoolEntry<T> entry) {
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        IX509CertificateFilter target = this.getCertificateFilter();
        if (target != null) {
            IFactory factory;
            IElement tempElement = element.newElementMapped("certificateFilter");
            if (target instanceof IElementSerializable) {
                ((IElementSerializable)target).serialize(tempElement);
            } else if (target instanceof IFactorySupport && (factory = ((IFactorySupport)target).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)target, tempElement);
            }
        }
    }

    public void setCertificateFilter(IX509CertificateFilter certificateFilter) {
        this.certificateFilter = certificateFilter;
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public void setPin(Secret pin) {
        this.pin = pin;
    }
}

