/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.impl;

import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.AuthenticationTimeout;
import de.intarsys.security.app.IRestrictedApplication;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.pool.impl.AcceptException;
import de.intarsys.security.device.pool.impl.CommonPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.impl.NullPoolListener;
import de.intarsys.security.device.pool.impl.PACKAGE;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPool<T extends ISecurityApplication>
extends CommonPool<T> {
    private static AtomicInteger activePoolCount = new AtomicInteger();
    private static final Logger Log = LoggerFactory.getLogger(GenericPool.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IPoolListener<T> poolListener = new NullPoolListener();
    private String typeDescription;

    protected static void decrementActive() {
        activePoolCount.decrementAndGet();
    }

    public static int getActivePoolCount() {
        return activePoolCount.get();
    }

    protected static void incrementActive() {
        activePoolCount.incrementAndGet();
    }

    public PoolEntry<T> addApplication(T app, String label) throws AcceptException {
        this.checkEntries();
        if (this.getMaxEntryCount() != -1 && this.getEntryCount() >= this.getMaxEntryCount()) {
            String msg = Msg.getString("GenericPool.ErrorAcceptMaxPoolSizeReached", new Object[]{this.getLabel()});
            throw new AcceptException(msg);
        }
        PoolEntry<T> entry = new PoolEntry<T>(this, app);
        entry.setLabel(label);
        entry.setMaxUptime(this.getMaxUptime());
        entry.setMaxUsageCount(this.getMaxUsageCount());
        entry.setNotificationPercentage(this.getNotificationPercentage());
        T t = entry.getSecurityApplication();
        if (t instanceof IRestrictedApplication) {
            IRestrictedApplication restrictedApp = (IRestrictedApplication)t;
            int restrictionCount = restrictedApp.getRestrictionCount();
            if (restrictionCount == 1) {
                String msg = Msg.getString("GenericPool.failSingleSignatureCertificate", new Object[]{this.getLabel()});
                throw new AcceptException(msg);
            }
            if (this.getMaxUsageCount() != -1 && restrictionCount > 0 && this.getMaxUsageCount() > restrictionCount) {
                String msg = Msg.getString("GenericPool.failMaxUsageCountSurpassesCardRestriction", new Object[]{this.getLabel(), this.getMaxUsageCount(), restrictionCount});
                throw new AcceptException(msg);
            }
        }
        this.authenticate(entry);
        this.entriesAdd(entry);
        return entry;
    }

    protected void authenticate(PoolEntry<T> entry) throws AcceptException {
        try {
            Log.debug("{} pool authenticate {}", (Object)this.getLogLabel(), entry);
            this.getPoolListener().authenticate(this, entry);
            String tmpMsg = Msg.getString("GenericPool.authenticationSuccess", new Object[]{this.getLabel(), entry.getLabel()});
            Log.info(tmpMsg);
        }
        catch (AuthenticationCanceled e) {
            String tmpMsg = Msg.getString("GenericPool.failAuthenticationCanceled", new Object[]{this.getLabel(), entry.getLabel(), ExceptionTools.getMessage((Throwable)e)});
            throw new AcceptException(tmpMsg);
        }
        catch (AuthenticationTimeout e) {
            String tmpMsg = Msg.getString("GenericPool.failAuthenticationTimeout", new Object[]{this.getLabel(), entry.getLabel(), ExceptionTools.getMessage((Throwable)e)});
            throw new AcceptException(tmpMsg);
        }
        catch (AuthenticationFailed e) {
            String tmpMsg = Msg.getString("GenericPool.failAuthenticationFailed", new Object[]{this.getLabel(), entry.getLabel(), ExceptionTools.getMessage((Throwable)e)});
            throw new AcceptException(tmpMsg);
        }
        catch (SecurityApplicationException e) {
            String tmpMsg = Msg.getString("GenericPool.failAuthenticationException", new Object[]{this.getLabel(), entry.getLabel(), ExceptionTools.getMessage((Throwable)e)});
            throw new AcceptException(tmpMsg);
        }
    }

    @Override
    protected void basicStart() {
        super.basicStart();
        this.checkLicenseActivePoolCount();
        this.checkLicensedActiveEntries();
    }

    @Override
    protected void entriesRemove(PoolEntry<T> entry, boolean retry) {
        super.entriesRemove(entry, retry);
        if (retry) {
            this.getPoolListener().retry(this, entry);
        }
    }

    public IPoolListener<T> getPoolListener() {
        return this.poolListener;
    }

    @Override
    public String getTypeDescription() {
        return this.typeDescription;
    }

    @Override
    protected void onStartAfter() {
        super.onStartAfter();
        GenericPool.incrementActive();
        this.getPoolListener().onStartAfter(this);
    }

    @Override
    protected void onStartBefore() {
        super.onStartBefore();
        this.getPoolListener().onStartBefore(this);
    }

    @Override
    protected void onStopAfter() {
        GenericPool.decrementActive();
        this.getPoolListener().onStopAfter(this);
        super.onStopAfter();
    }

    @Override
    protected void onStopBefore() {
        this.getPoolListener().onStopBefore(this);
        super.onStopBefore();
    }

    public void preferencesRestore(IPreferences prefPool) {
        String timeout;
        String autoStart = prefPool.get("autoStart");
        if (autoStart != null) {
            this.setAutoStart(Boolean.parseBoolean(autoStart));
        }
        if ((timeout = prefPool.get("timeout")) != null) {
            this.setTimeout(Long.valueOf(timeout));
        }
    }

    public void preferencesStore(IPreferences prefPool) {
        prefPool.put("autoStart", this.isAutoStart());
        prefPool.put("timeout", this.getTimeout());
    }

    public void setPoolListener(IPoolListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.poolListener = listener;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }
}

