/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.impl;

import de.intarsys.security.app.IRestrictedApplication;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.pool.impl.CommonPool;
import de.intarsys.security.device.pool.impl.PACKAGE;
import de.intarsys.tools.component.ExpirationPredicate;
import de.intarsys.tools.component.ExpireTimeout;
import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.PresentationAdapter;
import de.intarsys.tools.string.StringTools;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolEntry<T extends ISecurityApplication>
implements IExpirationSupport {
    private static int Counter = 0;
    private static final Logger Log = LoggerFactory.getLogger(PoolEntry.class);
    private static final int MAX_RETRIES_ON_EXCEPTION = 2;
    public static final String ARG_POOL = "pool";
    public static final String ARG_TIMEOUT = "timeout";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final int id;
    private ExpirationPredicate expiration = new ExpireTimeout(300000L);
    private String label;
    private long activated = 0L;
    private final long created = System.currentTimeMillis();
    private boolean active = false;
    private Set<String> notified = new HashSet<String>();
    private int maxUsageCount = -1;
    private int notificationPercentage = 10;
    private long validTo = -1L;
    private final CommonPool<?> pool;
    private AtomicInteger retriesOnExceptionCount = new AtomicInteger();
    private final T securityApplication;

    protected static ExpirationPredicate getDefaultExpiration() {
        return new ExpireTimeout(300000L);
    }

    public PoolEntry(CommonPool<?> pool, T app) {
        this.id = Counter++;
        this.pool = pool;
        this.securityApplication = app;
        this.label = Msg.getString("PoolEntry.label", new Object[0]);
    }

    public boolean check() {
        this.checkNotification();
        return this.getPool().fromEntryCheck(this);
    }

    protected void checkNotification() {
        if (this.getValidTo() != -1L) {
            long maxDiff;
            long diff = this.getValidTo() - System.currentTimeMillis();
            if (diff <= 0L) {
                this.triggerNotificationOnce("device.limitReached", "Maximale Verwendungsdauer f\u00fcr Poolger\u00e4t '" + this.getLabel() + "' abgelaufen");
            }
            if ((double)diff * 100.0 / (double)(maxDiff = this.getValidTo() - this.getCreated()) <= (double)this.getNotificationPercentage()) {
                this.triggerNotificationOnce("device.limitWarn", "Verbleibende Verwendungsdauer f\u00fcr Poolger\u00e4t '" + this.getLabel() + "' bei " + diff / 60000L + " Minuten");
            }
        }
        if (this.getMaxUsageCount() != -1) {
            int maxDiff;
            int diff = this.getMaxUsageCount() - this.getSecurityApplication().getUseCount();
            if (diff <= 0) {
                this.triggerNotificationOnce("device.limitReached", "Maximale Anzahl Verwendungen f\u00fcr Poolger\u00e4t '" + this.getLabel() + "' abgelaufen");
            }
            if ((double)diff * 100.0 / (double)(maxDiff = this.getMaxUsageCount()) <= (double)this.getNotificationPercentage()) {
                this.triggerNotificationOnce("device.limitWarn", "Verbleibende Anzahl Verwendungen f\u00fcr Poolger\u00e4t '" + this.getLabel() + "' bei " + diff);
            }
        }
    }

    protected void dispose() {
        Log.info("pool {} dispose application '{}'", (Object)this.getPool().getLabel(), (Object)StringTools.safeString((Object)this));
        this.getSecurityApplication().dispose();
    }

    public long getActivated() {
        return this.activated;
    }

    public long getCreated() {
        return this.created;
    }

    public ExpirationPredicate getExpiration() {
        return this.expiration;
    }

    public String getLabel() {
        return PresentationAdapter.create(this.getSecurityApplication(), (String)this.label).getLabel();
    }

    public int getMaxUsageCount() {
        int tempMaxUsage = this.maxUsageCount;
        int tempRestriction = -1;
        if (this.getSecurityApplication() instanceof IRestrictedApplication) {
            tempRestriction = ((IRestrictedApplication)this.getSecurityApplication()).getRestrictionCount();
        }
        if (tempMaxUsage == -1) {
            return tempRestriction;
        }
        if (tempRestriction == -1) {
            return tempMaxUsage;
        }
        return Math.min(tempRestriction, tempMaxUsage);
    }

    public int getNotificationPercentage() {
        return this.notificationPercentage;
    }

    public CommonPool getPool() {
        return this.pool;
    }

    public T getSecurityApplication() {
        return this.securityApplication;
    }

    public long getValidTo() {
        return this.validTo;
    }

    public void incRetriesOnExceptionCount() {
        this.retriesOnExceptionCount.incrementAndGet();
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public boolean isExpired() {
        if (!this.isValid()) {
            return true;
        }
        return this.expiration.isExpired();
    }

    public boolean isValid() {
        if (!this.getSecurityApplication().isValid()) {
            return false;
        }
        if (this.getValidTo() != -1L && this.getValidTo() < System.currentTimeMillis()) {
            return false;
        }
        if (this.getMaxUsageCount() != -1 && this.getSecurityApplication().getUseCount() >= this.getMaxUsageCount()) {
            return false;
        }
        return this.retriesOnExceptionCount.get() < 2;
    }

    public void release() {
        try {
            this.getPool().fromEntryRelease(this);
        }
        catch (Exception e) {
            Log.warn("{} error disposing {}", (Object)this.getPool(), (Object)this);
        }
    }

    protected synchronized void setActive(boolean active) {
        this.active = active;
        this.activated = active ? System.currentTimeMillis() : 0L;
    }

    public void setExpiration(ExpirationPredicate expiration) {
        if (expiration == null) {
            throw new NullPointerException("expiration cannot be null");
        }
        this.expiration = expiration;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMaxUptime(long maxUptime) {
        this.validTo = maxUptime == -1L ? -1L : this.getCreated() + maxUptime;
    }

    public void setMaxUsageCount(int maxUsageCount) {
        this.maxUsageCount = maxUsageCount;
    }

    public void setNotificationPercentage(int notificationPercentage) {
        this.notificationPercentage = notificationPercentage;
    }

    public String toString() {
        return "pool application-" + this.id + "(mc " + this.getMaxUsageCount() + ", uc " + this.getSecurityApplication().getUseCount() + ")";
    }

    public void touch() {
        this.expiration.touch();
    }

    protected void triggerNotification(String type, String message) {
        this.getPool().fromEntryNotification(this, type, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerNotificationOnce(String type, String message) {
        PoolEntry poolEntry = this;
        synchronized (poolEntry) {
            if (this.notified.contains(type)) {
                return;
            }
            this.notified.add(type);
        }
        this.triggerNotification(type, message);
    }
}

