/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.tsa.device;

import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.tsa.device.TSADeviceProvider;
import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.ITSASupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=TSADeviceProvider.class)
public class TSADevice
extends CommonDevice<TSADeviceProvider>
implements ITSASupport {
    private static final Logger Log = LoggerFactory.getLogger(TSADevice.class);
    private ITSA tsa;

    protected TSADevice(TSADeviceProvider provider, String id) {
        super((CommonDeviceProvider)provider, id);
    }

    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement eTsa = element.element("tsa");
        if (eTsa != null) {
            try {
                this.tsa = (ITSA)ElementTools.createObject((IElement)eTsa, ITSA.class, (Object)((Object)this), (IArgs)Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    public ITSA getTSA() {
        return this.tsa;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setName("service");
        element.setAttributeValue("class", ((Object)((Object)this)).getClass().getName());
        element.setAttributeValue("id", this.getId());
        if (this.tsa != null) {
            ElementTools.putObject((IElement)element, (String)"tsa", (Object)this.tsa);
        }
    }

    public void setTSA(ITSA tsa) {
        this.tsa = tsa;
    }
}

