/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.tsa.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.tsa.app.timestamp.TSATimestampCreatorFactory;
import de.intarsys.security.device.tsa.device.PACKAGE;
import de.intarsys.security.device.tsa.device.TSADevice;
import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.TSA;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class TSADeviceProvider
extends CommonDeviceProvider<TSADevice> {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected TSADevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        TSADevice device = new TSADevice(this, this.getId(args));
        IFactory tsaFactory = FactoryTools.lookupFactoryFor(ITSA.class);
        if (tsaFactory == null) {
            tsaFactory = FactoryTools.lookupFactoryFor(TSA.class);
        }
        if (tsaFactory != null) {
            ITSA tsa = (ITSA)tsaFactory.createInstance(args);
            device.setTSA(tsa);
        }
        return device;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        TSATimestampCreatorFactory descriptor = new TSATimestampCreatorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(ITimestampCreator.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
        Outlet.get().registerFactory("de.intarsys.security.device.tsa.device.TSADeviceFactory", (IFactory)this);
    }
}

