/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client;

import de.intarsys.cloudsuite.gears.core.client.CommonStub;
import de.intarsys.cloudsuite.gears.core.client.ExplorerStub;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.cloudsuite.gears.core.client.Protocol;
import de.intarsys.cloudsuite.gears.core.client.SignerStub;
import de.intarsys.cloudsuite.gears.core.client.TimestamperStub;
import de.intarsys.cloudsuite.gears.core.client.ViewerStub;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.RequestExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.ResponseExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.RequestSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResponseSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.RequestTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.ResponseTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.RequestViewerCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.ResponseViewerCreate;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.util.List;
import java.util.stream.Stream;

public class GearsStub
extends CommonStub {
    public GearsStub(Protocol protocol) {
        super(protocol);
    }

    public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs variables, IArgs args, ILocator ... locators) throws GearsServiceException {
        RequestExplorerCreate reqCreate = new RequestExplorerCreate();
        reqCreate.setConfiguration(configuration);
        reqCreate.setOptions(options);
        reqCreate.setVariables(variables);
        reqCreate.setArgs(args);
        for (ILocator locator : locators) {
            TransportDocument reqDoc = TransportDocument.builder().content(locator).build();
            reqCreate.getDocuments().add(reqDoc);
        }
        ResponseExplorerCreate response = this.getProtocol().postJson("/api/v1/flow/explorer/create", null, this.createParameters(), reqCreate, ResponseExplorerCreate.class);
        return this.createExplorer(response);
    }

    public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs variables, IArgs args, TransportDocument ... documents) throws GearsServiceException {
        RequestExplorerCreate reqCreate = new RequestExplorerCreate();
        reqCreate.setConfiguration(configuration);
        reqCreate.setOptions(options);
        reqCreate.setVariables(variables);
        reqCreate.setArgs(args);
        for (TransportDocument doc : documents) {
            reqCreate.getDocuments().add(doc);
        }
        ResponseExplorerCreate response = this.getProtocol().postJson("/api/v1/flow/explorer/create", null, this.createParameters(), reqCreate, ResponseExplorerCreate.class);
        return this.createExplorer(response);
    }

    public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs args, ILocator ... locators) throws GearsServiceException {
        return this.createExplorer(options, configuration, null, args, locators);
    }

    public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs args, TransportDocument ... documents) throws GearsServiceException {
        return this.createExplorer(options, configuration, null, args, documents);
    }

    protected ExplorerStub createExplorer(ResponseExplorerCreate response) throws GearsServiceException {
        return new ExplorerStub(this.getProtocol(), (ConversationalResponse)response);
    }

    public SignerStub createSigner(IArgs options, Object configuration, IArgs variables, IArgs args, ILocator ... locators) throws GearsServiceException {
        List<TransportDocument> documents = Stream.of(locators).map(locator -> TransportDocument.builder().content(locator).build()).toList();
        return this.createSigner(options, configuration, variables, args, (TransportDocument[])ArrayTools.toArray(TransportDocument.class, documents));
    }

    public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs variables, IArgs args, TransportDocument ... documents) throws GearsServiceException {
        RequestTimestamperCreate reqCreate = new RequestTimestamperCreate();
        reqCreate.setConfiguration(configuration);
        reqCreate.setOptions(options);
        reqCreate.setVariables(variables);
        reqCreate.setArgs(args);
        for (TransportDocument doc : documents) {
            reqCreate.getDocuments().add(doc);
        }
        return this.createTimestamper(reqCreate);
    }

    public SignerStub createSigner(IArgs options, Object configuration, IArgs variables, IArgs args, TransportDocument ... documents) throws GearsServiceException {
        RequestSignerCreate reqCreate = new RequestSignerCreate();
        reqCreate.setConfiguration(configuration);
        reqCreate.setOptions(options);
        reqCreate.setVariables(variables);
        reqCreate.setArgs(args);
        for (TransportDocument doc : documents) {
            reqCreate.getDocuments().add(doc);
        }
        return this.createSigner(reqCreate);
    }

    public TimestamperStub createTimestamper(RequestTimestamperCreate reqCreate) throws GearsServiceException {
        return this.createTimestamper(this.getProtocol().postJson("/api/v1/flow/timestamper/create", null, this.createParameters(), reqCreate, ResponseTimestamperCreate.class));
    }

    public SignerStub createSigner(IArgs options, Object configuration, IArgs args, ILocator ... locators) throws GearsServiceException {
        return this.createSigner(options, configuration, null, args, locators);
    }

    protected TimestamperStub createTimestamper(ResponseTimestamperCreate response) throws GearsServiceException {
        return new TimestamperStub(this.getProtocol(), (ConversationalResponse)response);
    }

    public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs args, ILocator ... locators) throws GearsServiceException {
        return this.createTimestamper(options, configuration, null, args, locators);
    }

    public SignerStub createSigner(IArgs options, Object configuration, IArgs args, TransportDocument ... documents) throws GearsServiceException {
        return this.createSigner(options, configuration, null, args, documents);
    }

    public SignerStub createSigner(RequestSignerCreate reqCreate) throws GearsServiceException {
        return this.createSigner(this.getProtocol().postJson("/api/v1/flow/signer/create", null, this.createParameters(), reqCreate, ResponseSignerCreate.class));
    }

    public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs variables, IArgs args, ILocator ... locators) throws GearsServiceException {
        List<TransportDocument> documents = Stream.of(locators).map(locator -> TransportDocument.builder().content(locator).build()).toList();
        return this.createTimestamper(options, configuration, variables, args, (TransportDocument[])ArrayTools.toArray(TransportDocument.class, documents));
    }

    protected SignerStub createSigner(ResponseSignerCreate response) throws GearsServiceException {
        return new SignerStub(this.getProtocol(), (ConversationalResponse)response);
    }

    public ViewerStub createViewer(IArgs options, Object configuration, IArgs variables, IArgs args, ILocator locator) throws GearsServiceException {
        RequestViewerCreate reqCreate = new RequestViewerCreate();
        reqCreate.setConfiguration(configuration);
        reqCreate.setOptions(options);
        reqCreate.setVariables(variables);
        reqCreate.setArgs(args);
        TransportDocument transDoc = TransportDocument.builder().content(locator).build();
        reqCreate.setDocument(transDoc);
        ResponseViewerCreate response = this.getProtocol().postJson("/api/v1/flow/viewer/create", null, this.createParameters(), reqCreate, ResponseViewerCreate.class);
        return this.createViewer(response);
    }

    public ViewerStub createViewer(IArgs options, Object configuration, IArgs args, ILocator locator) throws GearsServiceException {
        return this.createViewer(options, configuration, null, args, locator);
    }

    protected ViewerStub createViewer(ResponseViewerCreate response) throws GearsServiceException {
        return new ViewerStub(this.getProtocol(), (ConversationalResponse)response);
    }
}

