/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client;

import de.intarsys.cloudsuite.gears.core.client.CommonStub;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.cloudsuite.gears.core.client.Protocol;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.url.URLTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class PageStub
extends CommonStub {
    private final String pageUrl;

    public PageStub(Protocol protocol, String pageUrl) {
        super(protocol);
        this.pageUrl = pageUrl;
    }

    @Override
    protected Map<String, String> createParameters() {
        Map<String, String> params = super.createParameters();
        String stickyId = this.getStickyId();
        if (stickyId != null) {
            params.put(this.getProtocol().getStickyFieldName(), stickyId);
        }
        return params;
    }

    public String getContentAsString() throws GearsServiceException {
        return this.getProtocol().get(this.getPageUrl(), null, this.createParameters(), String.class);
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    protected String getStickyId() {
        String stickyFieldName = this.getProtocol().getStickyFieldName();
        if (StringTools.isEmpty((String)stickyFieldName)) {
            return null;
        }
        if (StringTools.isEmpty((String)this.getPageUrl())) {
            return null;
        }
        try {
            Map params = URLTools.getQueryParameters((URL)new URL(this.getPageUrl()));
            List values = (List)params.get(stickyFieldName);
            if (values != null && !values.isEmpty()) {
                return (String)values.get(0);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        return null;
    }
}

