/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.cloudsuite.gears.core.client.HttpConfiguration;
import de.intarsys.cloudsuite.gears.core.client.IRequestProcessor;
import de.intarsys.cloudsuite.gears.core.client.IResponseProcessor;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorDeserializer;
import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.jaxrs.exception.ResponseError;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Protocol {
    private static final Logger Log = LoggerFactory.getLogger(Protocol.class);
    private final URI endpoint;
    private final HttpConfiguration httpConfiguration;
    private final Client client;
    private String stickyFieldName = "sticky_id";
    private final List<IRequestProcessor> requestProcessors = new ArrayList<IRequestProcessor>();
    private final List<IResponseProcessor> responseProcessors = new ArrayList<IResponseProcessor>();

    public Protocol(Client client, URI endpoint) {
        this.client = client;
        this.endpoint = endpoint;
        this.httpConfiguration = new HttpConfiguration();
    }

    public Protocol(String endpoint) throws URISyntaxException {
        this(new URI(endpoint), new HttpConfiguration());
    }

    public Protocol(URI endpoint) {
        this(endpoint, new HttpConfiguration());
    }

    public Protocol(URI endpoint, HttpConfiguration httpConfiguration) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(httpConfiguration);
        this.httpConfiguration = httpConfiguration;
        this.endpoint = endpoint;
        this.client = this.createClient();
    }

    public Protocol(URL endpoint) throws URISyntaxException {
        this(endpoint.toURI(), new HttpConfiguration());
    }

    public Protocol(URL endpoint, HttpConfiguration httpConfiguration) throws URISyntaxException {
        this(endpoint.toURI(), httpConfiguration);
    }

    public void addRequestProcessor(IRequestProcessor requestProcessor) {
        this.requestProcessors.add(requestProcessor);
    }

    public void addResponseProcessor(IResponseProcessor responseProcessor) {
        this.responseProcessors.add(responseProcessor);
    }

    protected Client createClient() {
        SSLContext sslContext;
        HostnameVerifier hostnameVerifier;
        LoggingFeature logging = new LoggingFeature(Log, Level.TRACE, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
        JacksonJsonProvider jacksonProvider = new JacksonJsonProvider(this.createObjectMapper());
        ClientConfig config = new ClientConfig().register((Object)jacksonProvider).register((Object)logging).property("jersey.config.client.followRedirects", (Object)false);
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)config).connectTimeout(this.httpConfiguration.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.httpConfiguration.getReadTimeout(), TimeUnit.MILLISECONDS);
        if (this.httpConfiguration.isUseProxy()) {
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                Log.error("Proxy enabled, but system property http.proxyHost is not set; continuing without proxy");
            } else {
                String proxyScheme = proxyHost.startsWith("http") ? "" : "http://";
                String proxyPort = System.getProperty("http.proxyPort");
                String proxyUri = proxyPort == null ? proxyScheme + proxyHost : proxyScheme + proxyHost + ":" + proxyPort;
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPassword = System.getProperty("http.proxyPassword");
                ((ClientBuilder)((ClientBuilder)((ClientBuilder)builder.property("jersey.config.client.proxy.uri", (Object)proxyUri)).property("jersey.config.client.proxy.username", (Object)proxyUser)).property("jersey.config.client.proxy.password", (Object)proxyPassword)).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            }
        }
        if ((hostnameVerifier = this.httpConfiguration.getHostnameVerifier()) != null) {
            builder.hostnameVerifier(hostnameVerifier);
        }
        if ((sslContext = this.httpConfiguration.getSslContext()) != null) {
            builder.sslContext(sslContext);
        }
        return builder.build();
    }

    protected ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        DeserializationConfig dc = mapper.getDeserializationConfig();
        ContextAttributes attrs = ContextAttributes.getEmpty();
        ITransportItemLocatorFactory factory = new ITransportItemLocatorFactory(){
            private int counter;

            public ILocator createLocator(JsonParser parser, DeserializationContext ctxt) throws IOException {
                return new FileLocator(new File(TempTools.getTempDir(), "download-" + this.counter++ + ".bytes"));
            }
        };
        attrs = TransportDocumentLocatorDeserializer.setLocatorFactory((ContextAttributes)attrs, (ITransportItemLocatorFactory)factory);
        dc = dc.with(attrs);
        mapper.setConfig(dc);
        return mapper;
    }

    public <RES> RES get(String path, Map<String, String> headers, Map<String, String> params, Class<RES> responseType) throws GearsServiceException {
        WebTarget target = this.target(path);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder = builder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        for (IRequestProcessor iRequestProcessor : this.requestProcessors) {
            iRequestProcessor.process(builder);
        }
        try {
            Response response = builder.get();
            return this.handleResponse(response, responseType);
        }
        catch (ProcessingException processingException) {
            throw new GearsServiceException(processingException);
        }
        catch (GearsServiceException gearsServiceException) {
            throw gearsServiceException;
        }
    }

    public Client getClient() {
        return this.client;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public String getStickyFieldName() {
        return this.stickyFieldName;
    }

    protected <RES> RES handleResponse(Response response, Class<RES> responseType) throws GearsServiceException {
        try {
            ResponseError error;
            for (IResponseProcessor processor : this.responseProcessors) {
                response = processor.process(response);
            }
            if (responseType == Response.class) {
                return (RES)response;
            }
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                return (RES)response.readEntity(responseType);
            }
            if (response.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                throw new GearsServiceException(response.getStatus(), "unauthorized", "authentication failed");
            }
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)response.getMediaType()) && (error = (ResponseError)response.readEntity(ResponseError.class)) != null) {
                throw new GearsServiceException(response.getStatus(), error.getError().getCode(), error.getError().getMessage());
            }
            throw new GearsServiceException(response.getStatus(), "undefined", Optional.ofNullable(response.getStatusInfo().getReasonPhrase()).orElse("undefined"));
        }
        catch (GearsServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GearsServiceException(e);
        }
    }

    public <REQ, RES> RES postEntity(String path, Map<String, String> headers, Map<String, String> parameters, Entity<REQ> entity, Class<RES> responseType) throws GearsServiceException {
        WebTarget target = this.target(path);
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.WILDCARD_TYPE});
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder = builder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        for (IRequestProcessor iRequestProcessor : this.requestProcessors) {
            iRequestProcessor.process(builder);
        }
        try {
            Response response = builder.post(entity);
            return this.handleResponse(response, responseType);
        }
        catch (ProcessingException processingException) {
            throw new GearsServiceException(processingException);
        }
        catch (GearsServiceException gearsServiceException) {
            throw gearsServiceException;
        }
    }

    public <REQ, RES> RES postJson(String path, Map<String, String> headers, Map<String, String> parameters, REQ request, Class<RES> responseType) throws GearsServiceException {
        Entity entity = Entity.json(request);
        return this.postEntity(path, headers, parameters, entity, responseType);
    }

    public <REQ, RES> RES postJson(String path, Map<String, String> headers, REQ request, Class<RES> responseType) throws GearsServiceException {
        return this.postJson(path, headers, null, request, responseType);
    }

    public <REQ, RES> RES postJson(String path, REQ request, Class<RES> responseType) throws GearsServiceException {
        return this.postJson(path, null, null, request, responseType);
    }

    public boolean removeRequestProcessor(IRequestProcessor requestProcessor) {
        return this.requestProcessors.remove(requestProcessor);
    }

    public boolean removeResponseProcessor(IResponseProcessor responseProcessor) {
        return this.responseProcessors.remove(responseProcessor);
    }

    public void setStickyFieldName(String stickyFieldName) {
        this.stickyFieldName = stickyFieldName;
    }

    protected WebTarget target(String path) {
        URI uri = URI.create(path);
        if (uri.isAbsolute()) {
            return this.getClient().target(path);
        }
        return this.getClient().target(this.getEndpoint()).path(path);
    }
}

