/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client.auth;

import de.intarsys.cloudsuite.gears.core.client.auth.CommonAuthenticator;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.client.Invocation;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPasswordAuthenticator
extends CommonAuthenticator {
    private static final Logger Log = LoggerFactory.getLogger(UserPasswordAuthenticator.class);
    private String user;
    private Secret password;

    public UserPasswordAuthenticator() {
    }

    public UserPasswordAuthenticator(String user, Secret password) {
        this.user = user;
        this.password = password;
    }

    public UserPasswordAuthenticator(String user, String password) {
        this.user = user;
        this.password = Secret.hide((char[])password.toCharArray());
    }

    protected String createBasicToken(String user, Secret password) throws GeneralSecurityException {
        String plainToken = user + ":" + password.getString();
        return Base64.getEncoder().encodeToString(plainToken.getBytes(StandardCharsets.ISO_8859_1));
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public Invocation.Builder process(Invocation.Builder builder) {
        if (StringTools.isEmpty((String)this.getUser())) {
            Log.info("No remote gears user defined. HTTP Basic authentication is deactivated.");
            return builder;
        }
        try {
            return builder.header("Authorization", (Object)("Basic " + this.createBasicToken(this.user, this.password)));
        }
        catch (GeneralSecurityException e) {
            throw ExceptionTools.argumentInvalid((String)"authenticator", (String)"cannot create basic auth header", (Throwable)e);
        }
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

