/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.conversation;

import de.intarsys.cloudsuite.gears.core.client.ConversationStub;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.conversation.service.client.api.DtoCancelStage;
import de.intarsys.conversation.service.client.api.DtoErrorDetail;
import de.intarsys.conversation.service.client.api.DtoErrorStage;
import de.intarsys.conversation.service.client.api.DtoHttpRedirectStage;
import de.intarsys.conversation.service.client.api.DtoIdleStage;
import de.intarsys.conversation.service.client.api.DtoProcessingStage;
import de.intarsys.conversation.service.client.api.DtoReplyStage;
import de.intarsys.conversation.service.client.api.DtoRequestInputStage;
import de.intarsys.conversation.service.client.api.DtoResultStage;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.IdleStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.exception.ExceptionTools;

public class ConversationStubConversationAdapter {
    private final IConversation conversation;

    public ConversationStubConversationAdapter() {
        this.conversation = new Conversation("ConversationStubConversationAdapter");
    }

    public ConversationStubConversationAdapter(IConversation conversation) {
        this.conversation = conversation;
    }

    protected void acknowledge(ConversationStub stub, Object value) {
        try {
            stub.acknowledge(value);
            this.handle(stub);
        }
        catch (Exception e) {
            this.localError(stub, e);
        }
    }

    protected void cleanup(ConversationStub stub) {
        if (!stub.getReplyStage().isFinal()) {
            try {
                stub.cancel();
                stub.acknowledge();
            }
            catch (GearsServiceException gearsServiceException) {
                // empty catch block
            }
        }
    }

    protected void errorSchemeNotSupported(DtoReplyStage replyStage) {
        throw new UnsupportedOperationException("scheme '" + replyStage.getScheme() + "' not supported");
    }

    protected IReplyStage fromDto(DtoReplyStage dtoReplyStage) {
        if (dtoReplyStage instanceof DtoHttpRedirectStage) {
            DtoHttpRedirectStage dtoHttpRedirectStage = (DtoHttpRedirectStage)dtoReplyStage;
            return new HttpRedirectStage(dtoHttpRedirectStage.getUrl(), dtoHttpRedirectStage.isOutOfBand(), false);
        }
        if (dtoReplyStage instanceof DtoRequestInputStage) {
            DtoRequestInputStage dtoInputStage = (DtoRequestInputStage)dtoReplyStage;
            RequestInputStage inputStage = new RequestInputStage();
            inputStage.setType(dtoInputStage.getType());
            inputStage.setTitle(dtoInputStage.getTitle());
            inputStage.setMessage(dtoInputStage.getMessage());
            return inputStage;
        }
        if (dtoReplyStage instanceof DtoProcessingStage) {
            DtoProcessingStage dtoProcessingStage = (DtoProcessingStage)dtoReplyStage;
            ProcessingStage processingStage = new ProcessingStage();
            processingStage.setState(dtoProcessingStage.getState());
            processingStage.setMessage(dtoProcessingStage.getMessage());
            processingStage.setWork(dtoProcessingStage.getWork());
            processingStage.setWorked(dtoProcessingStage.getWorked());
            processingStage.setPollDelay(dtoProcessingStage.getPollDelay());
            return processingStage;
        }
        if (dtoReplyStage instanceof DtoIdleStage) {
            return new IdleStage();
        }
        this.errorSchemeNotSupported(dtoReplyStage);
        return null;
    }

    public IConversation getConversation() {
        return this.conversation;
    }

    public final void handle(ConversationStub stub) {
        try {
            DtoReplyStage replyStage = stub.getReplyStage();
            if (replyStage instanceof DtoCancelStage) {
                this.handleCancel(stub, replyStage);
            } else if (replyStage instanceof DtoErrorStage) {
                this.handleError(stub, replyStage);
            } else if (replyStage instanceof DtoResultStage) {
                this.handleResult(stub, replyStage);
            } else {
                this.handleForward(stub, replyStage);
            }
        }
        catch (RuntimeException e) {
            this.localError(stub, e);
        }
    }

    protected void handleCancel(ConversationStub stub, DtoReplyStage replyStage) {
        this.getConversation().cancel(true);
    }

    protected void handleError(ConversationStub stub, DtoReplyStage replyStage) {
        DtoErrorStage errorStage = (DtoErrorStage)replyStage;
        DtoErrorDetail error = errorStage.getError();
        GearsServiceException ex = new GearsServiceException(error.getCode(), error.getMessage());
        this.getConversation().completeExceptionally((Throwable)ex);
    }

    protected void handleForward(ConversationStub stub, DtoReplyStage replyStage) {
        IReplyStage forwardStage = this.fromDto(replyStage);
        forwardStage.onAck(value -> this.acknowledge(stub, value));
        this.getConversation().setReplyStage(forwardStage);
    }

    protected void handleResult(ConversationStub stub, DtoReplyStage replyStage) {
        DtoResultStage resultStage = (DtoResultStage)replyStage;
        this.getConversation().complete(resultStage.getResult());
    }

    protected void localError(ConversationStub stub, Exception e) {
        this.cleanup(stub);
        this.getConversation().completeExceptionally(ExceptionTools.unwrap((Throwable)e));
    }
}

