/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.cardos;

import de.intarsys.security.smartcard.app.common.AbstractInitializeCredentialApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.cardos.CmdIncrease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CardOsInitializeCredentialApp
extends AbstractInitializeCredentialApp {
    protected static final Logger Log = LoggerFactory.getLogger(CardOsInitializeCredentialApp.class);
    private Boolean cacheTransportPinActive = null;

    protected boolean isQSigTransportPinActive() throws CardApplicationException {
        if (this.cacheTransportPinActive != null) {
            return this.cacheTransportPinActive;
        }
        try {
            this.cacheTransportPinActive = Boolean.TRUE;
            CardFileSelector fsEfQesTransportPinState = this.getCardInfo().lookupFileSelector("EF.QES_TRANSPORT_PIN_STATE");
            byte[] pinState = this.getFileSystem().readRecord(fsEfQesTransportPinState, 0);
            for (int i = 0; i < pinState.length; ++i) {
                if (pinState[i] == 0) continue;
                this.cacheTransportPinActive = Boolean.FALSE;
                break;
            }
        }
        catch (CardFileNotFoundException e) {
            this.cacheTransportPinActive = Boolean.FALSE;
        }
        return this.cacheTransportPinActive;
    }

    protected void markPinsAsInitialized() throws CardApplicationException {
        this.cacheTransportPinActive = null;
        CardFileSelector fsEfQesTransportPinState = this.getCardInfo().lookupFileSelector("EF.QES_TRANSPORT_PIN_STATE");
        this.getFileSystem().selectEf(fsEfQesTransportPinState, false);
        CmdIncrease cmdIncrease = (CmdIncrease)this.getCommand(CmdIncrease.class);
        RequestAPDU request = cmdIncrease.create(0, 1);
        this.sendRequest((ICommand)cmdIncrease, request);
    }
}

