/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.cardos;

import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.security.smartcard.os.cardos.CardOsInitializeCredentialApp;
import de.intarsys.security.smartcard.os.cardos.PACKAGE;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.string.CharacterTools;
import java.util.ArrayList;
import java.util.Iterator;

public class InitializeCredentialMulticardApp
extends CardOsInitializeCredentialApp {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected void basicInitializeCredentialsGui() throws CardApplicationException {
        IMessage prompt;
        IMessage title;
        Secret transportPin;
        Iterator itPinInfo = this.getSupportedPinInfos().iterator();
        IPinInfo pinRefGlobal = (IPinInfo)itPinInfo.next();
        IPinInfo pinRefQSig = (IPinInfo)itPinInfo.next();
        if (pinRefGlobal.getReference() > 128) {
            IPinInfo temp = pinRefGlobal;
            pinRefGlobal = pinRefQSig;
            pinRefQSig = temp;
        }
        if (CryptoTools.isEmpty((Secret)(transportPin = this.getTransportPin(null)))) {
            title = this.getMsgTitleTransport(false);
            prompt = this.getMsgPromptTransport(false);
            transportPin = this.queryPin(title, prompt);
        }
        this.setPinInfo(pinRefGlobal);
        title = this.getMsgTitleNew(false);
        prompt = this.getMsgPromptNew(false);
        Secret newPinGlobal = this.queryPin(title, prompt);
        title = this.getMsgTitleRepeat(false);
        prompt = this.getMsgPromptRepeat(false);
        Secret repeatPin = this.queryPin(title, prompt);
        if (!LangTools.equals((Object)newPinGlobal, (Object)repeatPin)) {
            throw new CardAuthenticationFailedException(this.getMessage("AbstractInitializeCredentialApp.error.PinMismatch", new Object[0]).getString());
        }
        this.setPinInfo(pinRefQSig);
        title = this.getMsgTitleNew(false);
        prompt = this.getMsgPromptNew(false);
        Secret newPinQES = this.queryPin(title, prompt);
        title = this.getMsgTitleRepeat(false);
        prompt = this.getMsgPromptRepeat(false);
        repeatPin = this.queryPin(title, prompt);
        if (!LangTools.equals((Object)newPinQES, (Object)repeatPin)) {
            throw new CardAuthenticationFailedException(this.getMessage("AbstractInitializeCredentialApp.error.PinMismatch", new Object[0]).getString());
        }
        this.basicInitializeCredentialsLiteral(transportPin, new Secret[]{newPinGlobal, newPinQES});
    }

    protected void basicInitializeCredentialsLiteral(Secret transportPin, Secret[] newPins) throws CardApplicationException {
        if (!this.isQSigTransportPinActive()) {
            return;
        }
        if (CryptoTools.isEmpty((Secret)transportPin) && CryptoTools.isEmpty((Secret)(transportPin = this.getTransportPin(null)))) {
            throw new CardApplicationException("No transport PIN provided");
        }
        Iterator itPinInfo = this.getSupportedPinInfos().iterator();
        IPinInfo pinRefGlobal = (IPinInfo)itPinInfo.next();
        IPinInfo pinRefQSig = (IPinInfo)itPinInfo.next();
        if (pinRefGlobal.getReference() > 128) {
            IPinInfo temp = pinRefGlobal;
            pinRefGlobal = pinRefQSig;
            pinRefQSig = temp;
        }
        this.initializeGlobalPin(transportPin, newPins[0], pinRefGlobal);
        this.initializeQSigPin(transportPin, newPins[1], pinRefQSig);
        this.markPinsAsInitialized();
    }

    protected void basicInitializeCredentialsSpe() throws CardApplicationException {
        if (!this.isQSigTransportPinActive()) {
            return;
        }
        Secret transportPin = this.getTransportPin(null);
        if (CryptoTools.isEmpty((Secret)transportPin)) {
            throw new CardApplicationException("No transport PIN provided");
        }
        Iterator itPinInfo = this.getSupportedPinInfos().iterator();
        IPinInfo credGlobal = (IPinInfo)itPinInfo.next();
        IPinInfo credQSig = (IPinInfo)itPinInfo.next();
        if (credGlobal.getReference() > 128) {
            IPinInfo temp = credGlobal;
            credGlobal = credQSig;
            credQSig = temp;
        }
        this.speInitializeGlobalPin(credGlobal, transportPin);
        this.speInitializeQSigPin(credQSig, transportPin);
        this.markPinsAsInitialized();
    }

    protected String[] getMsgPromptArgs(IPinInfo credential) {
        String cardTerminalName = this.getCard().getCardTerminal().getName();
        String minSize = String.valueOf(credential.getPinCodec().getMinCharacters());
        String maxSize = credential.getPinCodec().getMaxCharacters() < 16 ? String.valueOf(credential.getPinCodec().getMaxCharacters()) : "16";
        return new String[]{credential.getLabel(), cardTerminalName, minSize, maxSize, String.valueOf(SmartcardEnvironment.get().getSpeTimeout())};
    }

    protected IMessage getMsgPromptDirect(String[] commonMsgArgs) {
        IMessage plainMsg = Msg.getMessage("InitializeCredentialMulticardApp.initializePinDirect", (Object[])commonMsgArgs);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptNew(String[] commonMsgArgs) {
        IMessage plainMsg = Msg.getMessage("InitializeCredentialMulticardApp.initializePinIndirectEnterNewPin", (Object[])commonMsgArgs);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptRepeat(String[] commonMsgArgs) {
        IMessage plainMsg = Msg.getMessage("InitializeCredentialMulticardApp.initializePinIndirectEnterRepeatNewPin", (Object[])commonMsgArgs);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage[] getMsgPrompts(IPinInfo credential, boolean direct) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>(3);
        String[] commonMsgArgs = this.getMsgPromptArgs(credential);
        if (direct) {
            messages.add(this.getMsgPromptDirect(commonMsgArgs));
        } else {
            messages.add(this.getMsgPromptNew(commonMsgArgs));
            messages.add(this.getMsgPromptRepeat(commonMsgArgs));
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    protected Secret getTransportPin(IPinInfo pinRef) throws CardApplicationException {
        try {
            CardFileSelector fsEfGlobalTransportPin = this.getCardInfo().lookupFileSelector("EF.GLOBAL_TRANSPORT_PIN");
            byte[] transportPin = this.getFileSystem().readBinary(fsEfGlobalTransportPin);
            return Secret.hide((char[])CharacterTools.toCharArray((byte[])transportPin));
        }
        catch (CardFileNotFoundException e) {
            return null;
        }
    }

    public void initializeCredential() throws CardApplicationException {
        if (this.getNewPins() != null) {
            this.basicInitializeCredentialsLiteral(this.getTransportPin(), this.getNewPins());
        } else if (this.isSupportedSPE()) {
            this.basicInitializeCredentialsSpe();
        } else {
            if (this.isEnforceSPE()) {
                throw new SpeRequiredException();
            }
            this.basicInitializeCredentialsGui();
        }
    }

    private void initializeGlobalPin(Secret transportPin, Secret newGlobalPIN, IPinInfo pinRefGlobal) throws CardApplicationException {
        IPinInfo piGlobalTransport = this.getCardInfo().lookupPinInfo("PIN.Global.Transport");
        this.getFileSystem().selectDf(piGlobalTransport.getDirectory(), false);
        if (!this.isVerified(piGlobalTransport)) {
            this.cmdVerify(piGlobalTransport, transportPin);
        }
        this.cmdChangeCredential(pinRefGlobal, newGlobalPIN);
    }

    protected void initializeQSigPin(Secret transportPin, Secret newQSigPIN, IPinInfo pinRefQSig) throws CardApplicationException {
        IPinInfo piDfQes = this.getCardInfo().lookupPinInfo("PIN.QES.Transport");
        this.getFileSystem().selectDf(piDfQes.getDirectory(), false);
        if (!this.isVerified(piDfQes)) {
            this.cmdVerify(piDfQes, transportPin);
        }
        this.cmdChangeCredential(pinRefQSig, newQSigPIN);
    }

    protected void speInitializeGlobalPin(IPinInfo pinInfo, Secret transportPin) throws CardApplicationException {
        IPinInfo piGlobalTransport = this.getCardInfo().lookupPinInfo("PIN.Global.Transport");
        this.getFileSystem().selectDf(piGlobalTransport.getDirectory(), false);
        if (!this.isVerified(piGlobalTransport)) {
            this.cmdVerify(piGlobalTransport, transportPin);
        }
        IMessage[] messages = this.getMsgPrompts(pinInfo, false);
        IPinCodec pinCodec = pinInfo.getPinCodec();
        ICmdChangeReferenceData cmdModify = (ICmdChangeReferenceData)this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = cmdModify.create(pinInfo.getReference(), pinCodec.getTemplate());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, false, messages);
        this.getCardProduct().checkResponse(template, response);
    }

    protected void speInitializeQSigPin(IPinInfo pinInfo, Secret transportPin) throws CardApplicationException {
        IPinInfo piDfQes = this.getCardInfo().lookupPinInfo("PIN.QES.Transport");
        this.getFileSystem().selectDf(piDfQes.getDirectory(), false);
        if (!this.isVerified(piDfQes)) {
            this.cmdVerify(piDfQes, transportPin);
        }
        IMessage[] messages = this.getMsgPrompts(pinInfo, false);
        IPinCodec pinCodec = pinInfo.getPinCodec();
        ICmdChangeReferenceData cmdModify = (ICmdChangeReferenceData)this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = cmdModify.create(pinInfo.getReference(), pinCodec.getTemplate());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, false, messages);
        this.getCardProduct().checkResponse(template, response);
    }
}

