/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.cardos;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.security.smartcard.model.cmd.ICmdVerify;
import de.intarsys.security.smartcard.os.cardos.CardOsInitializeCredentialApp;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;

public class InitializeCredentialSinglecardApp
extends CardOsInitializeCredentialApp {
    protected void basicInitializeCredentialLiteral(Secret pTransportPin, Secret pNewPin) throws CardApplicationException {
        IPinInfo piDfQes = this.getCardInfo().lookupPinInfo("PIN.QES.Transport");
        this.getFileSystem().selectDf(piDfQes.getDirectory(), false);
        if (!this.isVerified(piDfQes)) {
            this.cmdVerify(piDfQes, pTransportPin);
        }
        this.cmdChangeCredential(this.getPinInfo(), pNewPin);
        try {
            this.resetQSigPuk(this.getPinInfo());
        }
        catch (CardApplicationException e) {
            Log.error("Failed resetting QSig PUK:" + e.getLocalizedMessage(), (Throwable)e);
        }
        this.markPinsAsInitialized();
    }

    protected void basicInitializeCredentialSpe() throws CardApplicationException {
        IPinInfo piDfQes = this.getCardInfo().lookupPinInfo("PIN.QES.Transport");
        if (!piDfQes.getDirectory().equals(this.getPinInfo().getDirectory())) {
            return;
        }
        this.getFileSystem().selectDf(piDfQes.getDirectory(), false);
        IMessage[] messages = this.getMsgPrompts(true);
        ICmdVerify cmdVerify = (ICmdVerify)this.getCommand(ICmdVerify.class);
        RequestAPDU verifyTemplate = cmdVerify.create(piDfQes.getReference(), piDfQes.getPinCodec().getTemplate());
        ResponseAPDU response = this.getPinEntryApplication().sendVerifyRequest(verifyTemplate, piDfQes.getPinCodec(), messages[0]);
        ICommand cmd = this.getCommand(ICmdChangeReferenceData.class);
        this.getCardProduct().checkResponse(verifyTemplate, response);
        ICmdChangeReferenceData cmdModify = (ICmdChangeReferenceData)this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = cmdModify.create(this.getPinInfo().getReference(), this.getPinInfo().getPinCodec().getTemplate());
        IMessage[] modifyMessages = new IMessage[2];
        if (messages.length > 2) {
            System.arraycopy(messages, 1, modifyMessages, 0, 2);
        } else {
            modifyMessages = messages;
        }
        response = this.getPinEntryApplication().sendModifyRequest(template, this.getPinInfo().getPinCodec(), false, modifyMessages);
        this.getCardProduct().checkResponse(template, response);
        try {
            this.resetQSigPuk(this.getPinInfo());
        }
        catch (CardApplicationException e) {
            Log.error("Failed resetting QSig PUK:" + e.getLocalizedMessage(), (Throwable)e);
        }
        this.markPinsAsInitialized();
    }

    protected void resetQSigPuk(IPinInfo credential) throws CardApplicationException {
        IPinInfo puk = credential.getResettingPinInfo();
        if (puk != null) {
            this.cmdResetRetryCounter(puk);
        }
    }
}

