/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.cardos;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public class PinStateApp
extends AbstractPinStateApp {
    private Boolean cacheTransportPinActive = null;

    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (pinInfo.isResetPinInfo()) {
            return new PinStateUnknown(pinInfo, pinInfo.getResettingPinInfo() != null);
        }
        try {
            CardFileSelector fsDfQes = this.getCardInfo().lookupFileSelector("DF.QES");
            if (fsDfQes != null && fsDfQes.equals(pinInfo.getDirectory()) && this.isQSigTransportPinActive()) {
                return new PinStateTransport(pinInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PinStateUnknown(pinInfo, pinInfo.getResettingPinInfo() != null);
    }

    protected boolean isQSigTransportPinActive() throws CardApplicationException {
        if (this.cacheTransportPinActive != null) {
            return this.cacheTransportPinActive;
        }
        try {
            this.cacheTransportPinActive = Boolean.TRUE;
            CardFileSelector fsEfQesTransportPinState = this.getCardInfo().lookupFileSelector("EF.QES_TRANSPORT_PIN_STATE");
            byte[] pinState = this.getFileSystem().readRecordCached(fsEfQesTransportPinState, 0);
            for (int i = 0; i < pinState.length; ++i) {
                if (pinState[i] == 0) continue;
                this.cacheTransportPinActive = Boolean.FALSE;
                break;
            }
        }
        catch (CardFileNotFoundException e) {
            this.cacheTransportPinActive = Boolean.FALSE;
        }
        return this.cacheTransportPinActive;
    }
}

