/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.npa;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdTerminate;

public class CmdTerminate
extends AbstractCmd
implements ICommand {
    public static final int INS = 230;
    public static final int TERMINATE_PIN = 16;
    public static final int TERMINATE_KEY = 33;

    public RequestAPDU createTerminateKey(int reference) {
        byte[] tlvBytes = new byte[]{-74, 3, -124, 1, (byte)reference};
        RequestAPDU request = new RequestAPDU(this.getCla(), this.getIns(), 33, 0, tlvBytes, false);
        request.setLabel(this.getLabel() + " key " + reference);
        return request;
    }

    public RequestAPDU createTerminatePin(int reference) {
        RequestAPDU request = new RequestAPDU(this.getCla(), this.getIns(), 16, reference);
        request.setLabel(this.getLabel() + " pin " + reference);
        return request;
    }

    public Class getCommandType() {
        return ICmdTerminate.class;
    }

    public int getIns() {
        return 230;
    }

    public String getLabel() {
        return "terminate";
    }
}

