/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.starcos.common;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import java.util.Arrays;

public final class StarcosTools {
    public static RequestAPDU createGetChallenge() {
        RequestAPDU request = new RequestAPDU(0, 132, 0, 0, 16, false);
        request.setLabel("get challenge");
        return request;
    }

    public static RequestAPDU createGetProtocolData(int tag) {
        RequestAPDU request = new RequestAPDU(160, 202, tag >>> 8 & 0xFF, tag & 0xFF, 0, false);
        request.setLabel("get protocol data");
        return request;
    }

    public static byte[] getChallenge(ICardConnection connection) throws CardException {
        RequestAPDU request = StarcosTools.createGetChallenge();
        ResponseAPDU response = connection.transmit(request);
        return response.getData();
    }

    public static byte[] getChipSerial(ICardConnection connection) throws CardException {
        RequestAPDU request = StarcosTools.createGetProtocolData(40812);
        ResponseAPDU response = connection.transmit(request);
        return response.getData();
    }

    public static byte[] getImageID(ICardConnection connection) throws CardException {
        RequestAPDU request = StarcosTools.createGetProtocolData(40807);
        ResponseAPDU response = connection.transmit(request);
        return response.getData();
    }

    public static byte[] getProtocolData(ICardConnection connection) throws CardException {
        RequestAPDU request = StarcosTools.createGetProtocolData(57120);
        ResponseAPDU response = connection.transmit(request);
        return response.getData();
    }

    public static boolean matchImageId(ICardConnection connection, byte[] ... imageId) {
        try {
            byte[] privateDataObject = StarcosTools.getImageID(connection);
            byte[] tempId = new byte[4];
            System.arraycopy(privateDataObject, 0, tempId, 0, tempId.length);
            for (byte[] currentId : imageId) {
                if (!Arrays.equals(tempId, currentId)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private StarcosTools() {
    }
}

