/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.starcos.v32;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.dataobject.Atr;
import de.intarsys.security.smartcard.iso.dataobject.PreIssuingData;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.collection.ByteArrayTools;
import java.io.IOException;
import java.util.Arrays;

public class Starcos32Tools {
    public static final int LCS_CREATED = 1;
    public static final int LCS_INITIALIZATION = 3;
    public static final int LCS_ACTIVATED = 5;
    public static final int LCS_DEACTIVATED = 4;
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");
    public static final CardFilePath EF_PWDD = new CardFilePath("0015");
    public static final CardFilePath EF_KFPC = new CardFilePath("0016");
    public static final CardFilePath EF_GDO = new CardFilePath("3F00:2F02");
    public static final byte[] MANUFACTURER_GUD = new byte[]{68, 69, 71, 43, 68};

    public static int getKFPC(ICardProduct product, ICardConnection connection, IPinInfo pinRef) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        fileSystem.selectDf(pinRef.getDirectory(), false);
        byte[] kfpcEntry = fileSystem.readRecord((CardFileSelector)EF_KFPC, 1);
        int kfpc = kfpcEntry != null && kfpcEntry.length > 1 ? kfpcEntry[1] : -1;
        return kfpc;
    }

    public static byte[] getSerialNumber(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        try {
            Iso7816BerElement element;
            byte[] gdo = fileSystem.readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                return element.getValue();
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return new byte[0];
    }

    public static boolean isGuD(ICardConnection connection, IFileSystemApplication fs) {
        try {
            CardFileId atrFile = new CardFileId("2f01");
            byte[] bytes = fs.readBinary((CardFileSelector)atrFile);
            Atr atrDo = new Atr(Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length));
            PreIssuingData pid = atrDo.getCardData().getPreIssuingData();
            int chipManufacturer = pid.getChipManufacturer();
            byte[] cardManufacturer = pid.getCardManufacturer();
            if (Arrays.equals(cardManufacturer, MANUFACTURER_GUD)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTransportPinActive(ICardProduct product, ICardConnection connection, IPinInfo pinRef) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        fileSystem.selectDf(pinRef.getDirectory(), false);
        try {
            byte liveCycleState;
            byte[] pwddEntry = fileSystem.readRecord((CardFileSelector)EF_PWDD, 1);
            int index = ByteArrayTools.indexOf((byte[])pwddEntry, (int)0, (int)pwddEntry.length, (byte[])new byte[]{-118, 1}, (int)0, (int)2, (int)0);
            return index != -1 && index + 2 < pwddEntry.length && (liveCycleState = pwddEntry[index + 2]) == 3;
        }
        catch (CardFileNotFoundException e) {
            return false;
        }
    }
}

