/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.starcos.v34;

import de.intarsys.security.smartcard.os.starcos.v34.KeyDSeObject;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tools.tlv.common.TlvTemplateBasedObject;
import de.intarsys.tools.tlv.common.TlvTools;
import java.util.Iterator;

public class KeyDObject
extends TlvTemplateBasedObject {
    public static final int TAG_88 = 136;
    public static final int TAG_LCS = 138;
    public static final int TAG_98 = 152;
    public static final int TAG_SECURITY_MECHANISM = 123;
    public static final int TAG_KFPC = 144;
    public static final int TAG_OPERATION_COUNTER = 145;
    public static final int TAG_GENERATION_COUNTER = 146;
    public static final int TAG_KEY_RETRY_COUNTER = 150;
    public static final int LCS_INITIAL = 3;
    public static final int LCS_DEACTIVATED = 4;
    public static final int LCS_ACTIVATED = 5;

    public KeyDObject(TlvTemplate template) {
        super(template);
    }

    public int getGenerationCounter() {
        TlvElement tlv = this.getElementTagged(146);
        if (tlv == null) {
            return -1;
        }
        return TlvTools.asUnsignedInt((TlvElement)tlv);
    }

    public int getKFPC() {
        TlvElement tlv = this.getElementTagged(144);
        if (tlv == null) {
            return 0;
        }
        return TlvTools.asUnsignedInt((TlvElement)tlv);
    }

    public int getLifeCycleState() {
        TlvElement tlv = this.getElementTagged(138);
        if (tlv == null) {
            return 5;
        }
        return 0xFF & tlv.getValueAt(0);
    }

    public int getOperationCounter() {
        TlvElement tlv = this.getElementTagged(145);
        if (tlv == null) {
            return -1;
        }
        return TlvTools.asUnsignedInt((TlvElement)tlv);
    }

    public int getReferenceId() {
        TlvElement tlvR = this.getElementAt(0);
        if (tlvR == null) {
            return 0;
        }
        return 0xFF & tlvR.getValueAt(0);
    }

    public int getReferenceVersion() {
        TlvElement tlvR = this.getElementAt(0);
        if (tlvR == null) {
            return 0;
        }
        return 0xFF & tlvR.getValueAt(1);
    }

    public KeyDSeObject getSecurityEnvironment(int index) {
        Iterator<KeyDSeObject> it = this.getSecurityEnvironments();
        while (it.hasNext()) {
            KeyDSeObject se = it.next();
            if (se.getSecurityEnvironmentReference() != index) continue;
            return se;
        }
        return null;
    }

    public Iterator<KeyDSeObject> getSecurityEnvironments() {
        Iterator it = this.getTemplate().iteratorTagged(123);
        return new ConversionIterator<TlvElement, KeyDSeObject>(it){

            protected KeyDSeObject createTargetObject(TlvElement sourceObject) {
                return new KeyDSeObject(sourceObject.getTemplate());
            }
        };
    }
}

