/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.starcos.v34;

import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v32.Starcos32Tools;
import de.intarsys.security.smartcard.os.starcos.v34.PwdDObject;
import de.intarsys.security.smartcard.os.starcos.v34.PwdDSeObject;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Iterator;

public class Starcos34Tools {
    public static final int LCS_CREATED = 1;
    public static final int LCS_INITIALIZATION = 3;
    public static final int LCS_ACTIVATED = 5;
    public static final int LCS_DEACTIVATED = 4;
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");
    public static final CardFilePath EF_PWDD = new CardFilePath("0015");
    public static final CardFilePath EF_KFPC = new CardFilePath("0016");
    public static final CardFilePath EF_GDO = new CardFilePath("3F00:2F02");

    public static int getSecurityStatusEvaluationCounter(ICardProduct product, ICardConnection connection, IPinInfo pinInfo) {
        try {
            byte[][] pwddRecords;
            IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(pinInfo.getDirectory(), false);
            for (byte[] pwddRecord : pwddRecords = Starcos34Tools.readRecordsPwdd(product, connection)) {
                Iterator<PwdDSeObject> itSE;
                TlvTemplate pwddTemplate = Iso7816BerElement.parseTemplate((byte[])pwddRecord, (int)0, (int)pwddRecord.length);
                PwdDObject pwddObject = new PwdDObject(pwddTemplate);
                byte[] pwdReference = pwddObject.getPasswordReference();
                if (pwdReference[0] != (pinInfo.getReference() & 0x7F) || !(itSE = pwddObject.getSecurityEnvironmentObjects()).hasNext()) continue;
                PwdDSeObject seObject = itSE.next();
                return seObject.getSecurityStatusEvaluationCounter();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public static byte[] getSerialNumber(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        return Starcos32Tools.getSerialNumber(product, connection);
    }

    protected static byte[][] readRecordsPwdd(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        return fileSystem.readRecordsCached((CardFileSelector)EF_PWDD, -1);
    }

    private Starcos34Tools() {
    }
}

