/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.os.starcos.v35;

import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v35.KeyDObject;
import de.intarsys.security.smartcard.os.starcos.v35.KeyDSeObject;
import de.intarsys.tools.collection.ArrayIterator;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.IOException;
import java.util.Iterator;

public class Starcos35Tools {
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");
    public static final CardFilePath EF_GDO = new CardFilePath("3F00:2F02");

    public static Iterator<KeyDObject> getKeyDObjects(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        byte[][] keydRecords = fileSystem.readRecords((CardFileSelector)EF_KEYD, -1);
        return new ConversionIterator<byte[], KeyDObject>((Iterator)new ArrayIterator((Object[])keydRecords)){

            protected KeyDObject createTargetObject(byte[] bytes) {
                try {
                    TlvTemplate template = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length);
                    return new KeyDObject(template);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    public static int getLifeCycleState(ICardProduct product, ICardConnection connection, IPinInfo pinInfo) {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(pinInfo.getDirectory(), false);
            Iterator<KeyDObject> it = Starcos35Tools.getKeyDObjects(product, connection);
            while (it.hasNext()) {
                KeyDObject keydObject = it.next();
                int keyReference = keydObject.getReferenceId();
                if (keyReference != (pinInfo.getReference() & 0x7F)) continue;
                return keydObject.getLifeCycleState();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public static int getSecurityStatusEvaluationCounter(ICardProduct product, ICardConnection connection, IPinInfo pinInfo, int crt) {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(pinInfo.getDirectory(), false);
            Iterator<KeyDObject> it = Starcos35Tools.getKeyDObjects(product, connection);
            while (it.hasNext()) {
                KeyDObject keydObject = it.next();
                int keyReference = keydObject.getReferenceId();
                if ((keyReference & 0x7F) != (pinInfo.getReference() & 0x7F)) continue;
                KeyDSeObject seObject = keydObject.getSecurityEnvironment(0);
                if (seObject == null) {
                    return 1;
                }
                return seObject.getSecurityStatusEvaluationCounter(crt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public static String getSerialNumber(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)product.createCardApplication(connection, IFileSystemApplication.class);
        try {
            Iso7816BerElement element;
            byte[] gdo = fileSystem.readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                return HexTools.bytesToHexString((byte[])element.getValue());
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return "00";
    }

    private Starcos35Tools() {
    }
}

