/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.atrust;

import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.IDigest;
import jakarta.annotation.PostConstruct;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication {
    private static final Logger Log = LoggerFactory.getLogger(QSignApp.class);

    protected void basicResetSecurityStateCard() {
        try {
            this.getFileSystem().selectRoot(false);
            if (this.getApplicationPath() != null) {
                this.getFileSystem().selectDf(this.getApplicationPath(), false);
            }
        }
        catch (CardApplicationException e) {
            Log.warn("failed to reset security state (" + e.getMessage() + ")");
        }
    }

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IDigest digest = this.parseDigest(data);
        this.cmdMseSetComponentKeyAlgoRef(182, this.getCardHolderCertificate().getPrivateKeyInfo().getReference(), this.getDigestAlgoRef(digest.getAlgorithmName()));
        this.cmdPsoHashUpload(digest.getBytes());
        byte[] signatureBytes = this.cmdPsoComputeDigitalSignature(null).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signatureBytes, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    protected int getDigestAlgoRef(String algorithmName) {
        if ("SHA-1".equals(algorithmName)) {
            return 20;
        }
        if ("SHA-224".equals(algorithmName)) {
            return 52;
        }
        if ("SHA-256".equals(algorithmName)) {
            return 68;
        }
        return -1;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(1);
    }
}

