/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.bnotk.v10;

import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v34.Starcos34Tools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Iterator;

public class CardProduct
extends CiCardProduct {
    private int cardType = 0;
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");

    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        try {
            byte[] serial = Starcos34Tools.getSerialNumber((ICardProduct)this, connection);
            if (serial.length >= 6) {
                this.cardType = (serial[4] & 0xF) + ((serial[5] & 0xF0) >> 4);
            }
        }
        catch (CardApplicationException e) {
            this.cardType = 1;
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        try {
            IPinInfo pinInfo = this.getCardInfo().lookupPinInfo("PIN.QES");
            int index = Integer.parseInt(pinInfo.lookupProperty("keyd_index"));
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(pinInfo.getDirectory(), false);
            byte[] bytes = fileSystem.readRecord((CardFileSelector)EF_KEYD, index);
            if (bytes != null) {
                TlvTemplate template = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length);
                Iterator securityMechanisms = template.iteratorTagged(123);
                while (securityMechanisms.hasNext()) {
                    byte[] content;
                    TlvElement ssec;
                    TlvElement securityMechanism = (TlvElement)securityMechanisms.next();
                    TlvElement crte = securityMechanism.getTemplate().getElementTagged(164);
                    if (crte == null || (ssec = crte.getTemplate().getElementTagged(40738)) == null || (content = ssec.getValue()) == null || content.length <= 0) continue;
                    return content[0];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public int getCardType() {
        return this.cardType;
    }

    public boolean isAdvanced() {
        return this.getCardType() == 1;
    }

    public boolean isBatch() {
        return this.getCardType() == 4;
    }

    public boolean isMulti() {
        return this.getCardType() == 3;
    }

    public boolean isStandard() {
        return this.getCardType() == 2;
    }
}

