/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.debug;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.CardProductOutlet;
import de.intarsys.security.smartcard.model.CiCardProductFactory;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.tools.hex.HexTools;

public class DebugCardTools {
    public static String getSentApdu(ICardConnection connection) throws CardException {
        RequestAPDU getLastCommand = new RequestAPDU(128, 2, 0, 0, 127, false);
        ResponseAPDU resp = connection.transmit(getLastCommand);
        if (resp.getSw1() == 108) {
            getLastCommand = new RequestAPDU(128, 2, 0, 0, resp.getSw2(), false);
            resp = connection.transmit(getLastCommand);
        }
        return HexTools.bytesToHexString((byte[])resp.getData());
    }

    public static void selectDebugApplication(ICardConnection connection) throws CardException {
        byte[] data = HexTools.hexStringToBytes((String)"6EC81BC8E75E");
        RequestAPDU selectDebugApp = new RequestAPDU(0, 164, 4, 0, data, 127, false);
        connection.transmit(selectDebugApp);
    }

    public static void setupDebugCardProduct() {
        CiCardProductFactory factory = new CiCardProductFactory();
        factory.setCardInfoFile("/de/intarsys/security/smartcard/product/debug/card_v3-1.xml");
        CardProductOutlet.get().registerCardProductFactory((ICardProductFactory)factory);
    }
}

