/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dgn.v050sc32;

import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.common.StarcosTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tools.tlv.common.TlvTools;
import java.util.Arrays;
import java.util.Iterator;

public class CardProduct
extends CiCardProduct {
    private static final byte[] ImageIdDGNStarcos3_2_SSEC_1 = HexTools.hexStringToBytes((String)"01032308");
    private static final byte[] ImageIdDGNStarcos3_2_SSEC_254 = HexTools.hexStringToBytes((String)"01032309");

    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        if (!this.checkImageId(connection, ImageIdDGNStarcos3_2_SSEC_1, ImageIdDGNStarcos3_2_SSEC_254)) {
            return false;
        }
        return super.accept(factory, connection);
    }

    protected boolean checkImageId(ICardConnection connection, byte[] ... imageId) {
        try {
            byte[] privateDataObject = StarcosTools.getProtocolData(connection);
            for (TlvElement tlvPdoChild : Iso7816BerElement.parseTemplate((byte[])privateDataObject, (int)0, (int)privateDataObject.length)) {
                if (tlvPdoChild.getIdentifier() != 40808) continue;
                byte[] data = tlvPdoChild.getValue();
                if (data.length < 20) {
                    return false;
                }
                byte[] tempId = new byte[4];
                System.arraycopy(data, 8, tempId, 0, tempId.length);
                for (byte[] currentId : imageId) {
                    if (!Arrays.equals(tempId, currentId)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        int restriction = 1;
        try {
            restriction = this.readRestrictionFromEfPwdd(connection, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return restriction;
    }

    protected byte[] getPwddObject(ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
        return fileSystem.readRecord(this.getCardInfo().lookupFileSelector("AID_QES/EF.PWDD"), 1);
    }

    protected int readRestrictionFromEfPwdd(ICardConnection connection, int se) {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(this.getCardInfo().lookupFileSelector("AID_QES"), false);
            byte[] pwddObject = this.getPwddObject(connection);
            TlvTemplate tlvPwdd = Iso7816BerElement.parseTemplate((byte[])pwddObject, (int)0, (int)pwddObject.length);
            for (TlvElement tlvPwddChild : tlvPwdd) {
                if (tlvPwddChild.getIdentifier() != 123) continue;
                Iterator tlvSeIt = tlvPwddChild.getTemplate().iterator();
                while (tlvSeIt.hasNext()) {
                    TlvElement tlvSeChild = (TlvElement)tlvSeIt.next();
                    if (tlvSeChild.getIdentifier() != 128 || TlvTools.asInt((TlvElement)tlvSeChild) != se) continue;
                    while (tlvSeIt.hasNext()) {
                        tlvSeChild = (TlvElement)tlvSeIt.next();
                        if (tlvSeChild.getIdentifier() != 40738) continue;
                        int restriction = TlvTools.asUnsignedInt((TlvElement)tlvSeChild);
                        return restriction == 255 ? Integer.MAX_VALUE : restriction;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }
}

