/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dgn.v050sc32;

import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.hex.HexTools;
import jakarta.annotation.PostConstruct;

public class PSSEnabledQSignApp
extends AbstractSignApp
implements IQSignApplication {
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        RequestAPDU request = new RequestAPDU(HexTools.hexStringToBytes((String)"00 22 41 AA 04 89 02 14 30"));
        request.setLabel("mse set hash SHA256");
        ResponseAPDU response = this.sendRequest(null, request);
        this.cmdMseSetTemplate(mechanism, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        IDigest digest = this.parseDigest(data);
        byte[] bytes = digest.getBytes();
        this.cmdPsoHashUpload(bytes);
        return this.cmdPsoComputeDigitalSignature(new byte[0]).getData();
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    protected String[] getMechanismPrecedence() {
        return new String[]{"DST"};
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
    }
}

