/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dgn.v050sc32;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateActiveOrTransport;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v32.Starcos32Tools;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (pinInfo.isResetPinInfo()) {
            return new PinStateActive(pinInfo, -1);
        }
        boolean globalPin = "PIN.Global".equals(pinInfo.getId());
        this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
        ResponseAPDU resp = this.cmdVerify(pinInfo);
        int sw1 = resp.getSw1();
        int sw2 = resp.getSw2();
        if (sw1 == 105) {
            if (sw2 == 132) {
                return new PinStateTransport(pinInfo);
            }
        } else if (sw1 == 99 && (sw2 & 0xF0) == 192) {
            int retries = sw2 & 0xF;
            if (retries == 0) {
                return new PinStateLocked(pinInfo);
            }
            if (globalPin) {
                return new PinStateActiveOrTransport(pinInfo, retries);
            }
            return new PinStateActive(pinInfo, retries);
        }
        if (Starcos32Tools.isTransportPinActive(this.getCardProduct(), this.getCardConnection(), pinInfo)) {
            return new PinStateTransport(pinInfo);
        }
        try {
            int retries = Starcos32Tools.getKFPC(this.getCardProduct(), this.getCardConnection(), pinInfo);
            if (retries == 0) {
                return new PinStateLocked(pinInfo);
            }
            if (globalPin) {
                return new PinStateActiveOrTransport(pinInfo, retries);
            }
            return new PinStateActive(pinInfo, retries);
        }
        catch (Exception e) {
            return new PinStateUnknown(pinInfo);
        }
    }
}

