/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dgn.v050sc35;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.common.StarcosTools;
import de.intarsys.security.smartcard.os.starcos.v35.Starcos35Tools;
import de.intarsys.tools.hex.HexTools;

public class CardProduct
extends CiCardProduct {
    private static final byte[] ID_SC35_SINGLE = HexTools.hexStringToBytes((String)"0200000b");
    private static final byte[] ID_SC35_BATCH = HexTools.hexStringToBytes((String)"0200000c");
    private static final byte[] ID_SC35_MASS = HexTools.hexStringToBytes((String)"0200000e");
    private static final byte[] ID_SC35_SINGLE_TEST = HexTools.hexStringToBytes((String)"00c09b0b");
    private static final byte[] ID_SC35_BATCH_TEST = HexTools.hexStringToBytes((String)"00c09b0c");
    public static final String PREFIX_ARZT = "8027600108";
    public static final String PREFIX_PT = "8027600109";
    public static final String PREFIX_ZA = "8027600110";
    public static final String PREFIX_SERVICE = "927600353";

    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        if (!StarcosTools.matchImageId(connection, ID_SC35_SINGLE, ID_SC35_BATCH, ID_SC35_MASS, ID_SC35_SINGLE_TEST, ID_SC35_BATCH_TEST)) {
            return false;
        }
        return super.accept(factory, connection);
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        IPinInfo pin = this.getCardInfo().lookupPinInfo("PIN.CH.QES");
        return Starcos35Tools.getSecurityStatusEvaluationCounter((ICardProduct)this, connection, pin, 164);
    }
}

