/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v20;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;

public class CardProduct
extends Pkcs15CardProduct {
    @Override
    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        for (IPinInfo info : this.getCardInfo().getPinInfos()) {
            ((PinInfo)info).setTransportLength(5);
            IPinInfo puk = info.getResettingPinInfo();
            if (puk == null || puk.getReference() != 0) continue;
            if (info.getReference() > 128) {
                ((PinInfo)puk).setReference(138);
                continue;
            }
            ((PinInfo)puk).setReference(2);
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        if (this.isMulticard()) {
            return -1;
        }
        return 1;
    }

    public boolean isMulticard() {
        String label = this.getCardInfo().getPkcs15Structure().getP15TokenInfo().getLabel();
        return label.toLowerCase().contains("multicard");
    }

    public boolean isOfficerCard() {
        String label = this.getCardInfo().getPkcs15Structure().getP15TokenInfo().getLabel();
        return label.toLowerCase().contains("officer");
    }

    @Override
    public boolean isUseCT(Pkcs15CardHolderCertificateInfo certificateInfo) {
        if (this.isOfficerCard()) {
            return true;
        }
        return super.isUseCT(certificateInfo);
    }
}

