/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v20;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.dtrust.v20.CardProduct;
import jakarta.annotation.PostConstruct;

public class PinStateApp
extends de.intarsys.security.smartcard.os.cardos.PinStateApp {
    private boolean multicard;

    @Override
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        try {
            CardFileSelector fsDfQes = this.getCardInfo().lookupFileSelector("DF.QES");
            if ((this.multicard || fsDfQes != null && fsDfQes.equals(pinInfo.getDirectory())) && this.isQSigTransportPinActive()) {
                return new PinStateTransport(pinInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PinStateUnknown(pinInfo, pinInfo.getResettingPinInfo() != null);
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setMulticard(((CardProduct)this.getCardProduct()).isMulticard());
    }

    public boolean isMulticard() {
        return this.multicard;
    }

    public void setMulticard(boolean multicard) {
        this.multicard = multicard;
    }
}

