/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v20.officer;

import de.intarsys.security.encoding.PKCS1Type1Encoding;
import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import jakarta.annotation.PostConstruct;
import java.io.IOException;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication,
IAdvSignApplication {
    private Mechanism mechanism;

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        boolean useCT = cardProduct.isUseCT((Pkcs15CardHolderCertificateInfo)this.getCardHolderCertificate().getInfo());
        if (useCT) {
            byte[] padded;
            PKCS1Type1Encoding encoding = new PKCS1Type1Encoding();
            encoding.setIntendedLengthBits(this.getCardHolderCertificate().getKeyBitSize());
            try {
                padded = encoding.encode(data);
            }
            catch (IOException e) {
                throw CardApplicationException.create((Throwable)e);
            }
            this.cmdMseSetComponentKey(184, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
            return this.cmdPsoDecipher(padded, 0, 0).getData();
        }
        this.cmdMseSetComponentKey(182, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        return this.cmdPsoComputeDigitalSignature(data).getData();
    }

    protected IMechanism detectMechanism() throws CardApplicationException {
        return this.getMechanism();
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    protected Mechanism getMechanism() {
        return this.mechanism;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
        super.initialize();
        this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_SHA256);
        Mechanism tmpMech = new Mechanism();
        tmpMech.setHashAlgorithmNames("SHA256");
        tmpMech.setId("dst");
        tmpMech.setOperation("DST");
        tmpMech.setInputEncodingAlgorithmName("DigestInfo");
        tmpMech.setOutputEncodingAlgorithmName(null);
        this.setMechanism(tmpMech);
    }

    protected void setMechanism(Mechanism mechanism) {
        this.mechanism = mechanism;
    }
}

